/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.results;

import java.util.HashMap;
import org.eclipse.edt.ide.deployment.results.DeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.results.EGLDeployResultsView;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.results.SystemOutDeploymentResultsCollector;

public class DeploymentResultsCollectorManager {
    private static EGLDeployResultsView viewer;
    public static final DeploymentResultsCollectorManager INSTANCE;
    HashMap map = new HashMap();

    static {
        INSTANCE = new DeploymentResultsCollectorManager();
    }

    private DeploymentResultsCollectorManager() {
    }

    public void clear() {
        this.map = new HashMap();
    }

    public static DeploymentResultsCollectorManager getInstance() {
        return INSTANCE;
    }

    public IDeploymentResultsCollector getCollector(String subName, String name) {
        return this.getCollector(subName, name, false, false);
    }

    public IDeploymentResultsCollector getCollector(String subName, String name, boolean isDebug) {
        return this.getCollector(subName, name, isDebug, false);
    }

    public IDeploymentResultsCollector getCollector(String subName, String name, boolean isDebug, boolean isCMDMode) {
        String fullName = this.getName(subName, name, isDebug, isCMDMode);
        IDeploymentResultsCollector coll = (IDeploymentResultsCollector)this.map.get(fullName);
        if (coll == null) {
            coll = DeploymentResultsCollectorManager.createCollector(fullName, isCMDMode);
            this.map.put(fullName, coll);
        }
        return coll;
    }

    public void remove(IDeploymentResultsCollector coll) {
        this.map.remove(coll.getName());
    }

    private String getName(String ddName, String targetName, boolean isDebug, boolean isCMDMode) {
        return String.valueOf(targetName) + " (" + ddName + ")" + (isDebug ? "[Debug]" : "[Target]") + (isCMDMode ? "[CMDMode]" : "");
    }

    private static IDeploymentResultsCollector createCollector(String name, boolean isCMDMode) {
        if (!isCMDMode) {
            return new DeploymentResultsCollector(name, viewer);
        }
        return new SystemOutDeploymentResultsCollector(name);
    }
}

