/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.edt.debug.core.IEGLDebugTarget;
import org.eclipse.edt.debug.core.breakpoints.EGLLineBreakpoint;
import org.eclipse.edt.debug.internal.ui.actions.BreakpointUtils;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.editor.IEGLEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineTarget
implements IRunToLineTarget {
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        IEGLEditor eglEditor;
        String errorMessage = null;
        ITextEditor editor = BreakpointUtils.getEditor(part);
        IEGLEditor iEGLEditor = eglEditor = editor == null ? null : (IEGLEditor)editor.getAdapter(IEGLEditor.class);
        if (editor != null) {
            ITextSelection textSelection = (ITextSelection)selection;
            if (BreakpointUtils.isBreakpointValid(eglEditor, textSelection.getStartLine())) {
                IDocumentProvider provider = editor.getDocumentProvider();
                if (provider != null) {
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IStorageEditorInput) {
                        IStorage storage = ((IStorageEditorInput)input).getStorage();
                        IDocument document = provider.getDocument((Object)input);
                        if (storage instanceof IResource && document != null) {
                            IDebugTarget debugTarget;
                            errorMessage = "Could not locate debug target";
                            if (target instanceof IAdaptable && (debugTarget = (IDebugTarget)((IAdaptable)target).getAdapter(IDebugTarget.class)) != null) {
                                int line = eglEditor.getLineAtOffset(BreakpointUtils.getStatementNode(eglEditor, textSelection.getStartLine()).getOffset()) + 1;
                                IEGLElement element = BreakpointUtils.getElement((IResource)storage);
                                if (element != null) {
                                    String typeName = BreakpointUtils.getTypeName(element);
                                    if (typeName.length() > 0) {
                                        EGLLineBreakpoint bp = new EGLLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), typeName, line, -1, -1, false, true);
                                        RunToLineHandler handler = new RunToLineHandler(debugTarget, target, (IBreakpoint)bp);
                                        handler.run((IProgressMonitor)new NullProgressMonitor());
                                        return;
                                    }
                                    errorMessage = "Could not resolve type name";
                                } else {
                                    errorMessage = "Could not find IEGLElement";
                                }
                            }
                        } else {
                            errorMessage = "Missing document";
                        }
                    } else {
                        errorMessage = "Editor input not IStorageEditorInput";
                    }
                } else {
                    errorMessage = "Missing document provider";
                }
            } else {
                errorMessage = "Selected line is not a valid location to run to";
            }
        } else {
            errorMessage = "Not IEGLEditor";
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.edt.debug.ui", 150, errorMessage, null));
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IDebugElement) {
            IDebugElement element = (IDebugElement)target;
            IEGLDebugTarget adapter = (IEGLDebugTarget)element.getDebugTarget().getAdapter(IEGLDebugTarget.class);
            return adapter != null;
        }
        return false;
    }
}

