/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.edt.debug.core.PreferenceUtil;
import org.eclipse.edt.debug.core.java.filters.TypeFilterUtil;
import org.eclipse.edt.debug.core.java.variables.VariableUtil;
import org.eclipse.edt.ide.core.EDTRuntimeContainerEntry;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EDTDebugCorePlugin
extends Plugin
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.edt.debug.core";
    private static EDTDebugCorePlugin plugin;
    private String transformerPath;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        TypeFilterUtil.INSTANCE.dispose();
        VariableUtil.dispose();
        PreferenceUtil.savePreferences();
        plugin = null;
    }

    public static EDTDebugCorePlugin getDefault() {
        return plugin;
    }

    public String getTransformerPath() {
        if (this.transformerPath == null) {
            SimpleConfiguratorManipulator manipulator;
            ServiceReference ref;
            BundleContext context = this.getBundle().getBundleContext();
            if (context != null && (ref = context.getServiceReference(SimpleConfiguratorManipulator.class.getName())) != null && (manipulator = (SimpleConfiguratorManipulator)context.getService(ref)) != null) {
                try {
                    BundleInfo mainBundle = EDTRuntimeContainerEntry.findBestBundle((String)PLUGIN_ID, (BundleInfo[])manipulator.loadConfiguration(context, null), null);
                    if (mainBundle != null) {
                        URL bundleURL = FileLocator.toFileURL((URL)URIUtil.toURL((URI)mainBundle.getLocation()));
                        String path = bundleURL.getPath();
                        File file = new File(path = URLDecoder.decode(path, "UTF-8"));
                        if (file.isDirectory()) {
                            file = new File(file, "transformer.jar");
                        }
                        this.transformerPath = file.getAbsolutePath();
                    }
                }
                catch (IOException iOException) {}
            }
            if (this.transformerPath == null) {
                this.transformerPath = "";
            }
        }
        return this.transformerPath;
    }

    public static void log(IStatus status) {
        EDTDebugCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        if (t instanceof CoreException) {
            EDTDebugCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, t.getMessage(), t.getCause() == null ? t : t.getCause()));
        } else {
            EDTDebugCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 125, "Internal Error", t));
        }
    }
}

