/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.edt.debug.core.EDTDebugCoreMessages;
import org.eclipse.edt.debug.core.IEGLDebugElement;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugElement;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.SMAPUtil;
import org.eclipse.jdt.debug.core.IJavaStackFrame;

public class EGLWatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(final String expression, IDebugElement context, IWatchExpressionListener listener) {
        Object javaContext;
        if (context instanceof IEGLJavaDebugElement && (javaContext = ((IEGLJavaDebugElement)context).getJavaDebugElement()) instanceof IDebugElement) {
            IWatchExpressionDelegate delegate;
            boolean skipJavaDelegate = false;
            IJavaStackFrame frame = (IJavaStackFrame)((IDebugElement)javaContext).getAdapter(IJavaStackFrame.class);
            if (frame != null) {
                skipJavaDelegate = SMAPUtil.isEGLStratum(frame, (IEGLJavaDebugTarget)((IEGLJavaDebugElement)context).getDebugTarget());
            }
            if (!skipJavaDelegate && (delegate = DebugPlugin.getDefault().getExpressionManager().newWatchExpressionDelegate(((IDebugElement)javaContext).getModelIdentifier())) != null) {
                delegate.evaluateExpression(expression, (IDebugElement)javaContext, listener);
                return;
            }
        }
        if (expression.trim().length() == 0) {
            listener.watchEvaluationFinished(null);
        } else {
            IEGLDebugElement element = (IEGLDebugElement)context.getAdapter(IEGLDebugElement.class);
            if (element == null) {
                listener.watchEvaluationFinished(null);
            } else {
                listener.watchEvaluationFinished(new IWatchExpressionResult(){

                    public boolean hasErrors() {
                        return false;
                    }

                    public IValue getValue() {
                        return new IValue(){

                            public String getReferenceTypeName() throws DebugException {
                                return "";
                            }

                            public String getValueString() throws DebugException {
                                return EDTDebugCoreMessages.WatchExprsUnsupported;
                            }

                            public IVariable[] getVariables() throws DebugException {
                                return new IVariable[0];
                            }

                            public boolean hasVariables() throws DebugException {
                                return false;
                            }

                            public boolean isAllocated() throws DebugException {
                                return false;
                            }

                            public IDebugTarget getDebugTarget() {
                                return null;
                            }

                            public ILaunch getLaunch() {
                                return null;
                            }

                            public String getModelIdentifier() {
                                return null;
                            }

                            public Object getAdapter(Class adapter) {
                                return null;
                            }
                        };
                    }

                    public String getExpressionText() {
                        return expression;
                    }

                    public DebugException getException() {
                        return null;
                    }

                    public String[] getErrorMessages() {
                        return null;
                    }
                });
            }
        }
    }
}

