/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceUtil {
    private static IEclipsePreferences instanceNode;
    private static IEclipsePreferences defaultNode;

    private PreferenceUtil() {
    }

    public static void setToDefault(String key) {
        PreferenceUtil.getInstanceNode().remove(key);
    }

    public static void setDefaultString(String key, String value) {
        if (value == null) {
            PreferenceUtil.getDefaultNode().remove(key);
        } else {
            PreferenceUtil.getDefaultNode().put(key, value);
        }
    }

    public static void setDefaultBoolean(String key, boolean value) {
        PreferenceUtil.getDefaultNode().putBoolean(key, value);
    }

    public static String getDefaultString(String key, String defaultValue) {
        return PreferenceUtil.getDefaultNode().get(key, defaultValue);
    }

    public static boolean getDefaultBoolean(String key, boolean defaultValue) {
        return PreferenceUtil.getDefaultNode().getBoolean(key, defaultValue);
    }

    public static void setString(String key, String value) {
        if (value == null) {
            PreferenceUtil.getInstanceNode().remove(key);
        } else {
            PreferenceUtil.getInstanceNode().put(key, value);
        }
    }

    public static void setBoolean(String key, boolean value) {
        PreferenceUtil.getInstanceNode().putBoolean(key, value);
    }

    public static String getString(String key, String defaultValue) {
        return PreferenceUtil.getInstanceNode().get(key, defaultValue);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return PreferenceUtil.getInstanceNode().getBoolean(key, defaultValue);
    }

    public static synchronized void savePreferences() {
        try {
            PreferenceUtil.getDefaultNode().flush();
        }
        catch (BackingStoreException bse) {
            EDTDebugCorePlugin.log(bse);
        }
        try {
            PreferenceUtil.getInstanceNode().flush();
        }
        catch (BackingStoreException bse) {
            EDTDebugCorePlugin.log(bse);
        }
    }

    public static void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        PreferenceUtil.getInstanceNode().addPreferenceChangeListener(listener);
    }

    public static void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        PreferenceUtil.getInstanceNode().removePreferenceChangeListener(listener);
    }

    private static IEclipsePreferences getDefaultNode() {
        if (defaultNode == null) {
            defaultNode = new DefaultScope().getNode("org.eclipse.edt.debug.core");
        }
        return defaultNode;
    }

    private static IEclipsePreferences getInstanceNode() {
        if (instanceNode == null) {
            instanceNode = new InstanceScope().getNode("org.eclipse.edt.debug.core");
        }
        return instanceNode;
    }
}

