/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.GetLayoutPropertiesValuesOperation;
import org.eclipse.edt.ide.rui.document.utils.GetPropertiesValuesOperation;
import org.eclipse.edt.ide.rui.document.utils.PropertyValueVisitor;
import org.eclipse.edt.ide.rui.server.PropertyValue;

public class DocumentCache {
    private static final String WIDGET_PROCESSED_FLAG = "ProcessedFlag";
    private static final String LAYOUT_PROCESSED_FLAG = "Layout-ProcessedFlag";
    private HashMap CACHE = new HashMap();
    private IEGLDocument _currentDocument = null;
    private IFile _currentFile = null;

    public DocumentCache(IEGLDocument currentDocument, IFile currentFile) {
        this._currentDocument = currentDocument;
        this._currentFile = currentFile;
    }

    public void clear() {
        this.CACHE.clear();
    }

    public PropertyValue getPropertyValue(int iStatementOffset, int iStatementLength, String strPropertyName, String strPropertyType) {
        String key = String.valueOf(iStatementOffset) + "-" + iStatementLength + WIDGET_PROCESSED_FLAG;
        String propertyKey = String.valueOf(iStatementOffset) + "-" + iStatementLength + "-" + strPropertyName.toLowerCase();
        if (this.CACHE.containsKey(key)) {
            Object propertyObject = this.CACHE.get(propertyKey);
            if (propertyObject instanceof PropertyValue) {
                return (PropertyValue)propertyObject;
            }
            if (propertyObject instanceof Expression) {
                PropertyValueVisitor visitor = new PropertyValueVisitor(strPropertyType);
                visitor.processExpression((Expression)propertyObject);
                PropertyValue propertyValue = new PropertyValue(visitor.getResult(), visitor.propertyTypeMatch);
                this.CACHE.put(propertyKey, propertyValue);
                return propertyValue;
            }
            return null;
        }
        GetPropertiesValuesOperation operation = new GetPropertiesValuesOperation(this._currentDocument, this._currentFile);
        operation.visitProperties(iStatementOffset, iStatementLength);
        List assignments = operation.getAllProperties();
        if (assignments == null) {
            return null;
        }
        int i = 0;
        while (i < assignments.size()) {
            this.CACHE.put(String.valueOf(iStatementOffset) + "-" + iStatementLength + "-" + this.getIdentifier(((Assignment)assignments.get(i)).getLeftHandSide()), ((Assignment)assignments.get(i)).getRightHandSide());
            ++i;
        }
        this.CACHE.put(key, WIDGET_PROCESSED_FLAG);
        return this.getPropertyValue(iStatementOffset, iStatementLength, strPropertyName, strPropertyType);
    }

    public PropertyValue getLayoutPropertyValue(int iStatementOffset, int iStatementLength, String strPropertyName, String strPropertyType) {
        String key = String.valueOf(iStatementOffset) + "-" + iStatementLength + LAYOUT_PROCESSED_FLAG;
        String propertyKey = String.valueOf(iStatementOffset) + "-" + iStatementLength + LAYOUT_PROCESSED_FLAG + strPropertyName.toLowerCase();
        if (this.CACHE.containsKey(key)) {
            Object propertyObject = this.CACHE.get(propertyKey);
            if (propertyObject instanceof PropertyValue) {
                return (PropertyValue)propertyObject;
            }
            if (propertyObject instanceof Expression) {
                PropertyValueVisitor visitor = new PropertyValueVisitor(strPropertyType);
                visitor.processExpression((Expression)propertyObject);
                PropertyValue propertyValue = new PropertyValue(visitor.getResult(), visitor.propertyTypeMatch);
                this.CACHE.put(propertyKey, propertyValue);
                return propertyValue;
            }
            return null;
        }
        GetLayoutPropertiesValuesOperation operation = new GetLayoutPropertiesValuesOperation(this._currentDocument, this._currentFile);
        operation.visitProperties(iStatementOffset, iStatementLength);
        List assignments = operation.getAllProperties();
        if (assignments == null) {
            return null;
        }
        int i = 0;
        while (i < assignments.size()) {
            this.CACHE.put(String.valueOf(iStatementOffset) + "-" + iStatementLength + LAYOUT_PROCESSED_FLAG + this.getIdentifier(((Assignment)assignments.get(i)).getLeftHandSide()), ((Assignment)assignments.get(i)).getRightHandSide());
            ++i;
        }
        this.CACHE.put(key, LAYOUT_PROCESSED_FLAG);
        return this.getLayoutPropertyValue(iStatementOffset, iStatementLength, strPropertyName, strPropertyType);
    }

    private String getIdentifier(Expression expression) {
        if (expression instanceof SimpleName) {
            return ((SimpleName)expression).getIdentifier().toLowerCase();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getIdentifier().toLowerCase();
        }
        return "";
    }
}

