/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.mof.utils.NameUtile;

public class EGLContainerLocatorStrategy {
    private static final String CHILDREN_PROPERTY_NAME = NameUtile.getAsName((String)"children");
    private Node containerNode;
    private Node result;

    public EGLContainerLocatorStrategy(Node containerNode) {
        this.containerNode = containerNode;
    }

    public Node locateIndex(final int containerIndex) {
        if (this.containerNode != null) {
            this.containerNode.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(NewExpression newExpression) {
                    if (newExpression.hasSettingsBlock()) {
                        SettingsBlock settingsBlockOpt = newExpression.getSettingsBlock();
                        AssignmentLocator assignmentLocator = new AssignmentLocator(NameUtile.getAsName((String)CHILDREN_PROPERTY_NAME));
                        settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                        Assignment setting = assignmentLocator.getAssignment();
                        if (setting != null) {
                            ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(containerIndex);
                            setting.accept((IASTVisitor)visitor);
                            EGLContainerLocatorStrategy.this.result = visitor.theNode;
                        }
                    }
                    return false;
                }

                public boolean visit(SimpleName simpleName) {
                    Node parentNode = simpleName.getParent();
                    if (parentNode != null) {
                        parentNode.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                if (classDataDeclaration.hasSettingsBlock()) {
                                    SettingsBlock settingsBlockOpt = classDataDeclaration.getSettingsBlockOpt();
                                    AssignmentLocator assignmentLocator = new AssignmentLocator(CHILDREN_PROPERTY_NAME);
                                    settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                                    Assignment setting = assignmentLocator.getAssignment();
                                    if (setting != null) {
                                        ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(containerIndex);
                                        setting.accept((IASTVisitor)visitor);
                                        EGLContainerLocatorStrategy.this.result = visitor.theNode;
                                    }
                                }
                                return false;
                            }

                            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                                if (functionDataDeclaration.hasSettingsBlock()) {
                                    SettingsBlock settingsBlockOpt = functionDataDeclaration.getSettingsBlockOpt();
                                    AssignmentLocator assignmentLocator = new AssignmentLocator(CHILDREN_PROPERTY_NAME);
                                    settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                                    Assignment setting = assignmentLocator.getAssignment();
                                    if (setting != null) {
                                        ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(containerIndex);
                                        setting.accept((IASTVisitor)visitor);
                                        EGLContainerLocatorStrategy.this.result = visitor.theNode;
                                    }
                                }
                                return false;
                            }
                        });
                    }
                    return false;
                }
            });
        }
        return this.result;
    }

    private class ChildrenArrayVisitor
    extends DefaultASTVisitor {
        private int index;
        private Node theNode;

        public ChildrenArrayVisitor(int index) {
            this.index = index;
        }

        public boolean visit(Assignment assignment) {
            assignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(ArrayLiteral arrayLiteral) {
                    List expressions = arrayLiteral.getExpressions();
                    ChildrenArrayVisitor.this.theNode = (Node)expressions.get(ChildrenArrayVisitor.this.index);
                    return false;
                }
            });
            return false;
        }
    }
}

