/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class EGLContainerUpdateStrategy {
    private static final String CHILDREN_PROPERTY_NAME = NameUtile.getAsName((String)"children");
    private int theCharactersAdded = 0;
    private File fileAST;
    private Node containerNode;
    private IEGLDocument currentDocument;

    public EGLContainerUpdateStrategy(Node containerNode, IEGLDocument document) {
        this.containerNode = containerNode;
        this.currentDocument = document;
        this.fileAST = document.getNewModelEGLFile();
    }

    public int updateContainer(final String insertText, final int containerIndex) {
        if (this.containerNode != null) {
            this.containerNode.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(NewExpression newExpression) {
                    try {
                        if (newExpression.hasSettingsBlock()) {
                            SettingsBlock settingsBlockOpt = newExpression.getSettingsBlock();
                            AssignmentLocator assignmentLocator = new AssignmentLocator(NameUtile.getAsName((String)CHILDREN_PROPERTY_NAME));
                            settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                            Assignment setting = assignmentLocator.getAssignment();
                            if (setting != null) {
                                ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(insertText, containerIndex);
                                setting.accept((IASTVisitor)visitor);
                            } else {
                                ASTRewrite rewrite = ASTRewrite.create((File)EGLContainerUpdateStrategy.this.fileAST);
                                rewrite.addSimpleSetting(newExpression, CHILDREN_PROPERTY_NAME, "[ " + insertText + " ]");
                                rewrite.rewriteAST((IDocument)EGLContainerUpdateStrategy.this.currentDocument).apply((IDocument)EGLContainerUpdateStrategy.this.currentDocument);
                                EGLContainerUpdateStrategy.this.theCharactersAdded = CHILDREN_PROPERTY_NAME.length() + insertText.length() + 11;
                            }
                        } else {
                            ASTRewrite rewrite = ASTRewrite.create((File)EGLContainerUpdateStrategy.this.fileAST);
                            rewrite.addSimpleSetting(newExpression, CHILDREN_PROPERTY_NAME, "[ " + insertText + " ]");
                            rewrite.rewriteAST((IDocument)EGLContainerUpdateStrategy.this.currentDocument).apply((IDocument)EGLContainerUpdateStrategy.this.currentDocument);
                            EGLContainerUpdateStrategy.this.theCharactersAdded = CHILDREN_PROPERTY_NAME.length() + insertText.length() + 10;
                        }
                    }
                    catch (BadLocationException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Container Update: Error updating New Expression container", (Throwable)e));
                    }
                    return false;
                }

                public boolean visit(SimpleName simpleName) {
                    Node parentNode = simpleName.getParent();
                    if (parentNode != null) {
                        parentNode.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                try {
                                    if (classDataDeclaration.hasSettingsBlock()) {
                                        SettingsBlock settingsBlockOpt = classDataDeclaration.getSettingsBlockOpt();
                                        AssignmentLocator assignmentLocator = new AssignmentLocator(CHILDREN_PROPERTY_NAME);
                                        settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                                        Assignment setting = assignmentLocator.getAssignment();
                                        if (setting != null) {
                                            ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(insertText, containerIndex);
                                            setting.accept((IASTVisitor)visitor);
                                        } else {
                                            ASTRewrite rewrite = ASTRewrite.create((File)EGLContainerUpdateStrategy.this.fileAST);
                                            rewrite.addSimpleSetting(classDataDeclaration, CHILDREN_PROPERTY_NAME, "[ " + insertText + " ]");
                                            rewrite.rewriteAST((IDocument)EGLContainerUpdateStrategy.this.currentDocument).apply((IDocument)EGLContainerUpdateStrategy.this.currentDocument);
                                            EGLContainerUpdateStrategy.this.theCharactersAdded = CHILDREN_PROPERTY_NAME.length() + insertText.length() + 11;
                                        }
                                    } else {
                                        ASTRewrite rewrite = ASTRewrite.create((File)EGLContainerUpdateStrategy.this.fileAST);
                                        rewrite.addSimpleSetting(classDataDeclaration, CHILDREN_PROPERTY_NAME, "[ " + insertText + " ]");
                                        rewrite.rewriteAST((IDocument)EGLContainerUpdateStrategy.this.currentDocument).apply((IDocument)EGLContainerUpdateStrategy.this.currentDocument);
                                        EGLContainerUpdateStrategy.this.theCharactersAdded = CHILDREN_PROPERTY_NAME.length() + insertText.length() + 10;
                                    }
                                }
                                catch (BadLocationException e) {
                                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Container Update: Error updating Class Field container", (Throwable)e));
                                }
                                return false;
                            }

                            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                                try {
                                    if (functionDataDeclaration.hasSettingsBlock()) {
                                        SettingsBlock settingsBlockOpt = functionDataDeclaration.getSettingsBlockOpt();
                                        AssignmentLocator assignmentLocator = new AssignmentLocator(CHILDREN_PROPERTY_NAME);
                                        settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                                        Assignment setting = assignmentLocator.getAssignment();
                                        if (setting != null) {
                                            ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(insertText, containerIndex);
                                            setting.accept((IASTVisitor)visitor);
                                        } else {
                                            ASTRewrite rewrite = ASTRewrite.create((File)EGLContainerUpdateStrategy.this.fileAST);
                                            rewrite.addSimpleSetting(functionDataDeclaration, CHILDREN_PROPERTY_NAME, "[ " + insertText + " ]");
                                            rewrite.rewriteAST((IDocument)EGLContainerUpdateStrategy.this.currentDocument).apply((IDocument)EGLContainerUpdateStrategy.this.currentDocument);
                                            EGLContainerUpdateStrategy.this.theCharactersAdded = CHILDREN_PROPERTY_NAME.length() + insertText.length() + 11;
                                        }
                                    } else {
                                        ASTRewrite rewrite = ASTRewrite.create((File)EGLContainerUpdateStrategy.this.fileAST);
                                        rewrite.addSimpleSetting(functionDataDeclaration, CHILDREN_PROPERTY_NAME, "[ " + insertText + " ]");
                                        rewrite.rewriteAST((IDocument)EGLContainerUpdateStrategy.this.currentDocument).apply((IDocument)EGLContainerUpdateStrategy.this.currentDocument);
                                        EGLContainerUpdateStrategy.this.theCharactersAdded = CHILDREN_PROPERTY_NAME.length() + insertText.length() + 10;
                                    }
                                }
                                catch (BadLocationException e) {
                                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Container Update: Error updating Function Field container", (Throwable)e));
                                }
                                return false;
                            }
                        });
                    }
                    return false;
                }
            });
        }
        return this.theCharactersAdded;
    }

    private class ChildrenArrayVisitor
    extends DefaultASTVisitor {
        private String insertText;
        private int index;

        public ChildrenArrayVisitor(String insertText, int index) {
            this.insertText = insertText;
            this.index = index;
        }

        public boolean visit(final Assignment assignment) {
            assignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(ArrayLiteral array) {
                    try {
                        if (array.getExpressions().size() == 0) {
                            String childrenString = String.valueOf(CHILDREN_PROPERTY_NAME) + " = [ " + ChildrenArrayVisitor.this.insertText + " ]";
                            ASTRewrite rewrite = ASTRewrite.create((File)EGLContainerUpdateStrategy.this.fileAST);
                            rewrite.setText((Node)assignment, childrenString);
                            rewrite.rewriteAST((IDocument)EGLContainerUpdateStrategy.this.currentDocument).apply((IDocument)EGLContainerUpdateStrategy.this.currentDocument);
                            EGLContainerUpdateStrategy.this.theCharactersAdded = childrenString.length() - assignment.getLength();
                        } else {
                            String nodeText;
                            Node insertNode;
                            if (ChildrenArrayVisitor.this.index < array.getExpressions().size()) {
                                insertNode = (Node)array.getExpressions().get(ChildrenArrayVisitor.this.index);
                                nodeText = EGLContainerUpdateStrategy.this.currentDocument.get(insertNode.getOffset(), insertNode.getLength());
                                nodeText = String.valueOf(ChildrenArrayVisitor.this.insertText) + ", " + nodeText;
                            } else {
                                insertNode = (Node)array.getExpressions().get(ChildrenArrayVisitor.this.index - 1);
                                nodeText = EGLContainerUpdateStrategy.this.currentDocument.get(insertNode.getOffset(), insertNode.getLength());
                                nodeText = String.valueOf(nodeText) + ", " + ChildrenArrayVisitor.this.insertText;
                            }
                            ASTRewrite rewrite = ASTRewrite.create((File)EGLContainerUpdateStrategy.this.fileAST);
                            rewrite.setText(insertNode, nodeText);
                            rewrite.rewriteAST((IDocument)EGLContainerUpdateStrategy.this.currentDocument).apply((IDocument)EGLContainerUpdateStrategy.this.currentDocument);
                            EGLContainerUpdateStrategy.this.theCharactersAdded = ChildrenArrayVisitor.this.insertText.length() + 2;
                        }
                    }
                    catch (BadLocationException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Container Update: Error updating Array Literal of container", (Throwable)e));
                    }
                    return false;
                }
            });
            return false;
        }
    }
}

