/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.nls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.rui.internal.nls.ILocalesListViewer;
import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocaleUtility;
import org.eclipse.jface.preference.IPreferenceStore;

public class LocalesList {
    private static LocalesList singleton = null;
    List locales = new ArrayList();
    private Set changeListeners = new HashSet();

    public static LocalesList getLocalesList() {
        if (singleton == null) {
            singleton = new LocalesList();
            singleton.buildLocalesList();
        }
        return singleton;
    }

    public Locale createNewLocaleEntry(String code, String description, String runtimeLocaleCode) {
        Locale locale = new Locale(code, description, runtimeLocaleCode);
        this.locales.add(locale);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ILocalesListViewer)iterator.next()).addLocale(locale);
        }
        return locale;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ILocalesListViewer)iterator.next()).addLocale(locale);
        }
    }

    public void removeLocale(Locale locale) {
        this.locales.remove(locale);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ILocalesListViewer)iterator.next()).removeLocale(locale);
        }
    }

    public List getLocales() {
        return this.locales;
    }

    public void setLocales(List locales) {
        this.locales = locales;
    }

    public void clearLocales() {
        this.locales.clear();
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ILocalesListViewer)iterator.next()).clear();
        }
    }

    public void localeChanged(Locale locale) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ILocalesListViewer)iterator.next()).updateLocale(locale);
        }
    }

    public void removeChangeListener(ILocalesListViewer viewer) {
        this.changeListeners.remove(viewer);
        if (this.changeListeners.isEmpty()) {
            singleton = null;
        }
    }

    public void addChangeListener(ILocalesListViewer viewer) {
        this.changeListeners.add(viewer);
    }

    private void buildLocalesList() {
        this.locales.clear();
        String value = this.getEGLBasePreferenceStore().getString("org.eclipse.edt.ide.rui.eglRUIDefaultLocales");
        if (value != null && !value.equals("")) {
            String patternStr = ",";
            String[] fields = value.split(patternStr);
            if (fields.length % 3 != 0) {
                this.defaultTheLocalesList();
            } else {
                int i = fields.length / 3;
                int j = 0;
                while (j < i) {
                    int offset = j * 3;
                    Locale locale = new Locale(fields[0 + offset], fields[1 + offset], fields[2 + offset]);
                    this.addLocale(locale);
                    ++j;
                }
            }
            Collections.sort(this.locales, new SortIt());
        } else {
            this.defaultTheLocalesList();
        }
    }

    private IPreferenceStore getEGLBasePreferenceStore() {
        return EGLBasePlugin.getPlugin().getPreferenceStore();
    }

    public void defaultTheLocalesList() {
        this.clearLocales();
        for (Map.Entry mapEntry : LocaleUtility.DEFAULT_HANDLER_LOCALE_CODES.entrySet()) {
            String runtimeLocale = LocaleUtility.getDefaultRuntimeCodeForHandlerCode((String)mapEntry.getValue());
            Locale locale = new Locale((String)mapEntry.getValue(), (String)mapEntry.getKey(), runtimeLocale);
            this.addLocale(locale);
        }
        Collections.sort(this.locales, new SortIt());
    }

    public String toString() {
        String value = "";
        for (Locale locale : this.getLocales()) {
            value = value.equals("") ? locale.toString() : String.valueOf(value) + "," + locale.toString();
        }
        return value;
    }

    public class SortIt
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            String s1 = ((Locale)arg0).getDescription().toUpperCase();
            String s2 = ((Locale)arg1).getDescription().toUpperCase();
            return s1.compareTo(s2);
        }
    }
}

