/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.nls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.edt.ide.rui.internal.HelpContextIDs;
import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocaleUtility;
import org.eclipse.edt.ide.rui.internal.nls.RUINlsStrings;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewLocaleWizardPage
extends WizardPage {
    List currentDescriptions = new ArrayList();
    List currentCodes = new ArrayList();
    HashMap currentUserLocaleRuntimeLocaleCombinations;
    Locale locale;
    Text code;
    Text description;
    protected Combo runtimeLocaleChoicesCombo;

    public NewLocaleWizardPage(String pageName, String title, Locale locale, List currentCodes, List currentDescriptions, HashMap combinations) {
        super(pageName, title, null);
        this.currentCodes = currentCodes;
        this.currentDescriptions = currentDescriptions;
        this.locale = locale;
        this.currentUserLocaleRuntimeLocaleCombinations = combinations;
    }

    public void createControl(Composite parent) {
        Composite twoCols = new Composite(parent, 0);
        this.createDialogControls(twoCols);
        this.setControl((Control)twoCols);
        this.setPageComplete(this.validatePage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)twoCols, HelpContextIDs.RUI_New_Locale_Wizard);
        Dialog.applyDialogFont((Control)twoCols);
    }

    protected void createDialogControls(Composite twoCols) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 15;
        layout.marginWidth = 15;
        layout.marginHeight = 7;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        twoCols.setLayout((Layout)layout);
        twoCols.setLayoutData((Object)gridData);
        Label descriptionlabel = new Label(twoCols, 0);
        descriptionlabel.setText(RUINlsStrings.RUIDeployPreferencePage_4);
        gridData = new GridData();
        descriptionlabel.setLayoutData((Object)gridData);
        this.description = new Text(twoCols, 2048);
        gridData = new GridData(768);
        this.description.setLayoutData((Object)gridData);
        this.description.setFocus();
        this.description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLocaleWizardPage.this.setPageComplete(NewLocaleWizardPage.this.validatePage());
            }
        });
        Label codelabel = new Label(twoCols, 0);
        codelabel.setText(RUINlsStrings.RUIDeployPreferencePage_5);
        gridData = new GridData();
        codelabel.setLayoutData((Object)gridData);
        this.code = new Text(twoCols, 2048);
        gridData = new GridData(768);
        this.code.setLayoutData((Object)gridData);
        this.code.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLocaleWizardPage.this.setPageComplete(NewLocaleWizardPage.this.validatePage());
            }
        });
        Label runtimeMessageslabel = new Label(twoCols, 0);
        runtimeMessageslabel.setText(RUINlsStrings.RUIDeployPreferencePage_6);
        gridData = new GridData();
        runtimeMessageslabel.setLayoutData((Object)gridData);
        this.runtimeLocaleChoicesCombo = new Combo(twoCols, 8);
        gridData = new GridData(768);
        this.runtimeLocaleChoicesCombo.setLayoutData((Object)gridData);
        this.runtimeLocaleChoicesCombo.setItems(LocaleUtility.getRuntimeDescriptionsArray());
        if (this.locale.getRuntimeLocaleCode() == null) {
            this.runtimeLocaleChoicesCombo.setText(LocaleUtility.getRuntimeDescriptionsArray()[0]);
            this.locale.setRuntimeLocaleCode(LocaleUtility.getRuntimeCodeForDescription(this.runtimeLocaleChoicesCombo.getText()));
        } else {
            this.runtimeLocaleChoicesCombo.setText(LocaleUtility.getRuntimeDescriptionForCode(this.locale.getRuntimeLocaleCode()));
        }
        this.runtimeLocaleChoicesCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewLocaleWizardPage.this.setPageComplete(NewLocaleWizardPage.this.validatePage());
            }
        });
    }

    protected boolean validatePage() {
        String error = "";
        String code = this.code.getText();
        String runtimeCode = LocaleUtility.getRuntimeCodeForDescription(this.runtimeLocaleChoicesCombo.getText());
        if (this.description.getText().equals("")) {
            error = RUINlsStrings.NewLocaleDialog_Please_enter_a_unique_locale_descri_;
        } else if (code.equals("")) {
            error = RUINlsStrings.NewLocaleDialog_Please_enter_a_unique_locale_cod_;
        } else if (this.currentUserLocaleRuntimeLocaleCombinations.containsKey(code)) {
            List runtimes = (List)this.currentUserLocaleRuntimeLocaleCombinations.get(code);
            if (runtimes.contains(runtimeCode)) {
                error = RUINlsStrings.NewLocaleDialog_locale_combo_already_exists;
            } else if (this.currentDescriptions.contains(this.description.getText())) {
                error = RUINlsStrings.NewLocaleDialog_The_description_is_not_uniqu_;
            }
        }
        if (error.length() > 0) {
            this.setMessage(error, 3);
            return false;
        }
        this.setMessage(null);
        this.locale.setCode(code);
        this.locale.setDescription(this.description.getText());
        this.locale.setRuntimeLocaleCode(runtimeCode);
        return true;
    }
}

