/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import java.lang.reflect.Field;
import org.eclipse.edt.ide.rui.server.AbstractPreviewContext;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.server.EvServer;
import org.eclipse.edt.ide.rui.server.IContext;
import org.eclipse.edt.ide.rui.server.IServerContentProvider;
import org.eclipse.edt.ide.rui.server.IServerListener;
import org.eclipse.edt.ide.rui.server.PreviewContext;
import org.eclipse.edt.ide.rui.server.PreviewPaneContentProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvPreviewPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class EvPreviewBrowserManager
implements IServerListener,
ProgressListener {
    protected boolean _bRefreshing = false;
    protected Browser _browser = null;
    protected AbstractPreviewContext _context = null;
    protected Integer _intKey = null;
    protected EvPreviewPage _pagePreview = null;
    protected String _strURL = null;

    public EvPreviewBrowserManager(Browser browser, String strURL, EvEditorProvider editorProvider) {
        this._browser = browser;
        this._intKey = this.getContextKey();
        this._strURL = strURL;
        this.appendContextKey();
        this._context = this.createContext(editorProvider);
        EvServer.getInstance().addContext((IContext)this._context);
    }

    public EvPreviewBrowserManager(Browser browser, String strURL, EvPreviewPage pagePreview, EvEditorProvider editorProvider) {
        this._browser = browser;
        this._intKey = this.getContextKey();
        this._strURL = strURL;
        this._pagePreview = pagePreview;
        this.appendContextKey();
        this._context = this.createContext(editorProvider);
        EvServer.getInstance().addContext((IContext)this._context);
    }

    public void acceptWidgetPositions(String positionInfo) {
    }

    protected void appendContextKey() {
        this._strURL = this._strURL.indexOf("?") == -1 ? String.valueOf(this._strURL) + "?contextKey=" + this._intKey : String.valueOf(this._strURL) + "&contextKey=" + this._intKey;
    }

    public void changed(ProgressEvent event) {
    }

    public void completed(ProgressEvent event) {
        if (!this._bRefreshing) {
            return;
        }
        this._browser.removeProgressListener((ProgressListener)this);
        this._browser.setRedraw(true);
        this._bRefreshing = false;
    }

    protected AbstractPreviewContext createContext(EvEditorProvider editorProvider) {
        return new PreviewContext(this._strURL, this._intKey, (IServerContentProvider)new PreviewPaneContentProvider(editorProvider), (IServerListener)this);
    }

    protected Integer getContextKey() {
        return new Integer(EvServer.getInstance().generateContextKey());
    }

    protected Object getField(Object object, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    public String getURL() {
        return this._strURL;
    }

    public synchronized void refreshBrowser(boolean fullRefresh) {
        if (this._bRefreshing || this._browser == null) {
            return;
        }
        this._bRefreshing = true;
        final String strURLFinal = this._strURL;
        Display display = this._browser.getDisplay();
        if (!display.isDisposed()) {
            if (fullRefresh) {
                this._browser.addProgressListener((ProgressListener)this);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EvPreviewBrowserManager.this._browser.setRedraw(false);
                        EvPreviewBrowserManager.this.setBrowserUrl(strURLFinal);
                    }
                });
            } else {
                this._browser.execute("if (window.egl) { egl.evTerminateReloadHandler(); } else { document.location = \"" + strURLFinal + "\";}");
                this._bRefreshing = false;
            }
        }
    }

    public synchronized void refreshBrowserIncremental() {
        if (this._browser == null) {
            return;
        }
        final String strURLFinal = this._strURL;
        Display display = this._browser.getDisplay();
        if (!display.isDisposed()) {
            this._browser.addProgressListener((ProgressListener)this);
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EvPreviewBrowserManager.this._browser.execute("if (window.egl) { egl.evTerminateReloadHandler(); } else { document.location = \"" + strURLFinal + "\";}");
                }
            });
        }
    }

    public void doWidgetClick(Point point) {
        if (this._browser == null) {
            return;
        }
        EvServer.getInstance().doWidgetClick((IContext)this._context, point.x, point.y);
    }

    public synchronized void changeProperty(final WidgetPart widget, final String property, final String value, final int totalCharactersChanged) {
        if (this._browser == null) {
            return;
        }
        Display display = this._browser.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EvServer.getInstance().changeProperty((IContext)EvPreviewBrowserManager.this._context, widget.getBounds().x, widget.getBounds().y, widget.getBounds().width, widget.getBounds().height, property, value, totalCharactersChanged);
                }
            });
        }
    }

    public synchronized void moveWidget(final WidgetPart widget, final WidgetPart targetParent, final int oldIndex, final int newIndex, final int[] charactersChanged) {
        if (this._browser == null) {
            return;
        }
        Display display = this._browser.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EvServer.getInstance().moveWidget((IContext)EvPreviewBrowserManager.this._context, widget.getBounds().x, widget.getBounds().y, widget.getBounds().width, widget.getBounds().height, targetParent.getBounds().x, targetParent.getBounds().y, targetParent.getBounds().width, targetParent.getBounds().height, oldIndex, newIndex, charactersChanged);
                }
            });
        }
    }

    public synchronized void deleteWidget(final WidgetPart widget, final int totalCharactersRemoved) {
        if (this._browser == null) {
            return;
        }
        Display display = this._browser.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EvServer.getInstance().deleteWidget((IContext)EvPreviewBrowserManager.this._context, widget.getBounds().x, widget.getBounds().y, widget.getBounds().width, widget.getBounds().height, totalCharactersRemoved);
                }
            });
        }
    }

    public synchronized void refreshBrowserProperty(WidgetPart widget) {
        if (this._browser == null) {
            return;
        }
        Display display = this._browser.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EvServer.getInstance().refreshBrowserIncremental((IContext)EvPreviewBrowserManager.this._context);
                }
            });
        }
    }

    public void selectTextInEditor(int offset, int length) {
        if (this._pagePreview == null) {
            return;
        }
        this._pagePreview.getEditor().getPageSource().selectAndReveal(offset, length);
        this._pagePreview.getEditor().showPage(1);
    }

    protected void setBrowserUrl(String url) {
        this._browser.setUrl(url);
    }

    public void terminate() {
        EvServer.getInstance().removeContext((IContext)this._context);
    }
}

