/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.palette;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.palette.EvPaletteCreationEntry;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BidiUtils;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.IWidgetDescriptorRegistryListener;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetCreationFactory;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorGroup;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class EvPaletteRoot
extends PaletteRoot
implements IWidgetDescriptorRegistryListener,
IPropertyChangeListener {
    protected Map _mapNodeTypeToImageDescriptor = new TreeMap();
    protected static HashMap _paletteRootMap = new HashMap();
    private IProject project = null;

    public static EvPaletteRoot getInstance(IProject project) {
        EvPaletteRoot _instance = null;
        if (_paletteRootMap.containsKey(project.getName())) {
            _instance = (EvPaletteRoot)_paletteRootMap.get(project.getName());
        } else {
            _instance = new EvPaletteRoot(project);
            IPreferenceStore preferences = EDTCoreIDEPlugin.getPlugin().getPreferenceStore();
            preferences.addPropertyChangeListener((IPropertyChangeListener)_instance);
            _paletteRootMap.put(project.getName(), _instance);
        }
        return _instance;
    }

    public static ImageDescriptor getImageDescriptorForNodeType(String strNodeTypeID) {
        for (EvPaletteRoot root : _paletteRootMap.values()) {
            if (root._mapNodeTypeToImageDescriptor.containsKey(strNodeTypeID)) {
                return (ImageDescriptor)root._mapNodeTypeToImageDescriptor.get(strNodeTypeID);
            }
            Set setKeys = root._mapNodeTypeToImageDescriptor.keySet();
            for (String strNodeID : setKeys) {
                if (!strNodeID.endsWith(strNodeTypeID)) continue;
                return (ImageDescriptor)root._mapNodeTypeToImageDescriptor.get(strNodeID);
            }
        }
        return null;
    }

    private EvPaletteRoot(IProject project) {
        this.project = project;
        WidgetDescriptorRegistry.getInstance(project).addWidgetDescriptorRegistryListener(this);
    }

    protected Object getPaletteItem(WidgetDescriptorGroup group) {
        String strGroupName = group.getName();
        if (strGroupName == null) {
            return null;
        }
        String strGroupNameTranslated = this.translateGroupName(strGroupName);
        PaletteDrawer drawer = new PaletteDrawer(strGroupNameTranslated);
        ImageDescriptor smallIcon = group.getIconSmall();
        ImageDescriptor largeIcon = group.getIconLarge();
        drawer.setSmallIcon(smallIcon);
        drawer.setLargeIcon(largeIcon);
        drawer.setInitialState(1);
        ArrayList<CombinedTemplateCreationEntry> drawerEntries = new ArrayList<CombinedTemplateCreationEntry>();
        ArrayList listWidgetDescriptors = group.getWidgetDescriptors();
        boolean isBidi = BidiUtils.isBidi();
        int i = 0;
        while (i < listWidgetDescriptors.size()) {
            WidgetDescriptor widgetDescriptor = (WidgetDescriptor)listWidgetDescriptors.get(i);
            CombinedTemplateCreationEntry groupElement = this.getPaletteEntry(widgetDescriptor);
            if (isBidi || !isBidi && !groupElement.getLabel().startsWith("BIDI")) {
                drawerEntries.add(groupElement);
            }
            ++i;
        }
        if (drawerEntries.isEmpty()) {
            return null;
        }
        drawer.addAll(drawerEntries);
        return drawer;
    }

    protected CombinedTemplateCreationEntry getPaletteEntry(WidgetDescriptor descriptor) {
        EvPaletteCreationEntry entry = null;
        ImageDescriptor smallIcon = descriptor.getIconSmall();
        ImageDescriptor largeIcon = descriptor.getIconLarge();
        String strID = descriptor.getID();
        String strLabel = descriptor.getProvider() != null && descriptor.getProvider().length() != 0 ? String.valueOf(descriptor.getLabel()) + " (" + descriptor.getProvider() + ")" : descriptor.getLabel();
        String strDescription = descriptor.getDescription();
        entry = new EvPaletteCreationEntry(strLabel, strDescription, strID, WidgetCreationFactory.getInstance(), smallIcon, largeIcon, false);
        this._mapNodeTypeToImageDescriptor.put(strID, smallIcon);
        return entry;
    }

    protected String translateGroupName(String strGroupName) {
        if (strGroupName == null) {
            return null;
        }
        if (strGroupName.equals("EGL Widgets")) {
            return Messages.NL_EGL_Widgets;
        }
        return strGroupName;
    }

    public void updatePalette() {
        ArrayList<PaletteDrawer> listPaletteDrawers = new ArrayList<PaletteDrawer>();
        WidgetDescriptorRegistry registry = WidgetDescriptorRegistry.getInstance(this.project);
        Iterator iterGroups = registry.getDescriptorGroups();
        while (iterGroups.hasNext()) {
            WidgetDescriptorGroup group = (WidgetDescriptorGroup)iterGroups.next();
            Object objPaletteItem = this.getPaletteItem(group);
            if (!(objPaletteItem instanceof PaletteDrawer)) continue;
            PaletteDrawer drawer = (PaletteDrawer)objPaletteItem;
            drawer.setInitialState(2);
            listPaletteDrawers.add(drawer);
        }
        this.setChildren(listPaletteDrawers);
    }

    @Override
    public void widgetDescriptorRegistryChanged() {
        this.updatePalette();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }
}

