/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.edt.ide.rui.visualeditor.internal.util.TableCellEditor;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.TableCellEditorComboBoxListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableCellEditorComboBox
extends TableCellEditor {
    protected TableCellEditorComboBoxListener _listener = null;
    protected String[] _straOptions = null;
    protected String _strOriginalValue = null;

    public void activate(Table table, TableEditor tableEditor, int iColumn, TableItem tableItemSelected, String[] straOptions) {
        this._straOptions = straOptions;
        ComboBoxCellEditor cellEditor = new ComboBoxCellEditor();
        cellEditor.setStyle(8);
        super.activate(table, tableEditor, (CellEditor)cellEditor, iColumn, tableItemSelected);
        cellEditor.setItems(straOptions);
        this._strOriginalValue = tableItemSelected.getText(iColumn);
        if (this._strOriginalValue != null) {
            int iIndex = -1;
            int i = 0;
            while (i < straOptions.length) {
                if (straOptions[i].equals(this._strOriginalValue)) {
                    iIndex = i;
                    break;
                }
                ++i;
            }
            if (iIndex > -1) {
                cellEditor.setValue((Object)new Integer(iIndex));
            }
        }
    }

    public void addTableCellEditorComboListener(TableCellEditorComboBoxListener listener) {
        this._listener = listener;
    }

    @Override
    public void applyCellEditorValue(TableItem tableItem, CellEditor cellEditor, int iColumn) {
        if (tableItem == null || tableItem.isDisposed() || iColumn < 0) {
            return;
        }
        String strText = tableItem.getText(iColumn);
        if (cellEditor != null) {
            Object objValue = cellEditor.getValue();
            if (objValue == null) {
                return;
            }
            int iOption = (Integer)objValue;
            if (iOption < 0) {
                return;
            }
            String strNewValue = this._straOptions[iOption];
            if (!strText.equals(strNewValue)) {
                tableItem.setText(iColumn, strNewValue);
                if (this._listener != null) {
                    this._listener.cellComboBoxChanged(tableItem, iColumn, iOption, this._strOriginalValue, strNewValue);
                }
            }
        }
    }
}

