/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.DataMapping;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.DataTemplate;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.IWidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.IWidgetDescriptorRegistryListener;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorFactory;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorGroup;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.swt.widgets.Display;

public class WidgetDescriptorRegistry
implements IWidgetDescriptorRegistry {
    protected static HashMap _widgetDescriptorMap = new HashMap();
    protected TreeMap _hashDescriptorGroups = new TreeMap();
    protected HashMap _hashDescriptors = new HashMap();
    protected HashMap<String, List<DataTemplate>> _hashDataTemplateMappings = new HashMap();
    protected ArrayList _listListeners = new ArrayList();
    protected IProject _project = null;

    private void buildHashDataTemplateMapping() {
        Collection descriptors = this._hashDescriptors.values();
        for (WidgetDescriptor descriptor : descriptors) {
            if (descriptor.getDataTemplates() == null) continue;
            for (DataTemplate dataTemplate : descriptor.getDataTemplates()) {
                EnumerationEntry[] purposes;
                EnumerationEntry[] enumerationEntryArray = purposes = dataTemplate.getPurposes();
                int n = purposes.length;
                int n2 = 0;
                while (n2 < n) {
                    EnumerationEntry[] mappings;
                    EnumerationEntry _purpose = enumerationEntryArray[n2];
                    DataMapping dataMapping = dataTemplate.getDataMapping();
                    EnumerationEntry[] enumerationEntryArray2 = mappings = dataMapping.getMappings();
                    int n3 = mappings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        EnumerationEntry mapping = enumerationEntryArray2[n4];
                        String key = new StringBuffer(_purpose.getCaseSensitiveName()).append(".").append(dataMapping.isForArray()).append(".").append(dataMapping.isContainer()).append(".").append(mapping.getCaseSensitiveName()).toString();
                        List<DataTemplate> dataTemplates = this._hashDataTemplateMappings.get(key.toString());
                        if (dataTemplates == null) {
                            dataTemplates = new ArrayList<DataTemplate>();
                            this._hashDataTemplateMappings.put(key, dataTemplates);
                        }
                        dataTemplates.add(dataTemplate);
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    public static WidgetDescriptorRegistry getInstance(IProject project) {
        WidgetDescriptorRegistry _instance = null;
        if (_widgetDescriptorMap.containsKey(project.getName())) {
            _instance = (WidgetDescriptorRegistry)_widgetDescriptorMap.get(project.getName());
        } else {
            _instance = new WidgetDescriptorRegistry(project);
            _instance.initializeRegistry();
            _widgetDescriptorMap.put(project.getName(), _instance);
        }
        return _instance;
    }

    private WidgetDescriptorRegistry(IProject project) {
        this._project = project;
    }

    public void addWidgetDescriptorRegistryListener(IWidgetDescriptorRegistryListener listener) {
        if (!this._listListeners.contains(listener)) {
            this._listListeners.add(listener);
        }
    }

    protected void createWidgetDescriptorFromEglar(WidgetDescriptorFactory factory, String packageName, String elementName, IPart part, File eglarFile) {
        factory.setEglarFile(eglarFile);
        this.createWidgetDescriptor(factory, packageName, elementName, part);
    }

    protected void createWidgetDescriptor(WidgetDescriptorFactory factory, String packageName, String elementName, IPart part) {
        WidgetDescriptor widgetDescriptor = factory.createWidgetDescriptor(NameUtile.getAsName((String)packageName), NameUtile.getAsName((String)part.getElementName()));
        if (widgetDescriptor != null) {
            this.debug("RUIWidget: " + elementName);
            String groupName = widgetDescriptor.getGroup();
            if (groupName != null && groupName != "") {
                WidgetDescriptorGroup widgetGroup = (WidgetDescriptorGroup)this._hashDescriptorGroups.get(groupName);
                if (widgetGroup == null) {
                    widgetGroup = new WidgetDescriptorGroup();
                    widgetGroup.setID(widgetDescriptor._strGroup);
                    widgetGroup.setName(widgetDescriptor._strGroup);
                    this._hashDescriptorGroups.put(widgetGroup.getID(), widgetGroup);
                }
                if (widgetGroup != null) {
                    widgetGroup.addWidgetDescriptor(widgetDescriptor);
                }
            }
            this._hashDescriptors.put(widgetDescriptor.getID(), widgetDescriptor);
        }
    }

    private List getParts(IEGLFile file) {
        ArrayList<IPart> result = new ArrayList<IPart>();
        try {
            IPart[] allParts = file.getAllParts();
            int i = 0;
            while (i < allParts.length) {
                IPart part = allParts[i];
                if (((SourcePart)part).isExternalType() || ((SourcePart)part).isHandler()) {
                    result.add(part);
                }
                ++i;
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "Error reading parts from file: " + file.getElementName(), (Throwable)e));
        }
        return result;
    }

    @Override
    public WidgetDescriptor getDescriptor(String strWidgetTypeID) {
        if (strWidgetTypeID == null) {
            return null;
        }
        if (this._hashDescriptors.containsKey(strWidgetTypeID)) {
            return (WidgetDescriptor)this._hashDescriptors.get(strWidgetTypeID);
        }
        return null;
    }

    @Override
    public WidgetDescriptor getDescriptor(String strPackageName, String strWidgetType) {
        if (strPackageName == null || strWidgetType == null) {
            return null;
        }
        String strWidgetID = String.valueOf(strPackageName) + "@@" + strWidgetType;
        Set setKeys = this._hashDescriptors.keySet();
        for (String strDescriptorID : setKeys) {
            if (!strDescriptorID.endsWith(strWidgetID)) continue;
            return (WidgetDescriptor)this._hashDescriptors.get(strDescriptorID);
        }
        return null;
    }

    @Override
    public Iterator getDescriptorGroups() {
        return this._hashDescriptorGroups.values().iterator();
    }

    private void initializeRegistry() {
        new SystemUpdater().schedule();
    }

    public void reinitialize() {
        new UserUpdater().schedule();
    }

    public void removeWidgetDescriptorRegistryListener(IWidgetDescriptorRegistryListener listener) {
        if (this._listListeners.contains(listener)) {
            this._listListeners.remove(listener);
        }
    }

    private void debug(String s) {
    }

    @Override
    public List<DataTemplate> getMappingDescriptorDataTemplates(String purpose, String eglDataType, Set<String> eglDataTypeDetails, boolean forArray, boolean isContainer) {
        ArrayList<DataTemplate> dataTemplates = new ArrayList<DataTemplate>();
        String firstKey = new StringBuffer(purpose).append(".").append(forArray).append(".").append(isContainer).append(".").toString();
        eglDataTypeDetails.add(eglDataType);
        for (String eglDataTypeDetail : eglDataTypeDetails) {
            List<DataTemplate> fitDataTemplates = this._hashDataTemplateMappings.get(String.valueOf(firstKey) + eglDataTypeDetail);
            if (fitDataTemplates == null || fitDataTemplates.isEmpty()) continue;
            dataTemplates.addAll(fitDataTemplates);
        }
        return dataTemplates;
    }

    protected class SystemUpdater
    extends Updater {
        public SystemUpdater() {
            this.setUser(false);
            this.setSystem(true);
        }
    }

    protected class Updater
    extends Job {
        boolean cancelled;

        public Updater() {
            super(Messages.NL_WidgetRegistryUpdateJob_Name);
            this.cancelled = false;
            this.setRule(new UpdaterSchedulingRule());
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.initializeRegistry(monitor);
            return Status.OK_STATUS;
        }

        protected void initializeRegistry(IProgressMonitor monitor) {
            block13: {
                WidgetDescriptorRegistry.this._hashDescriptorGroups.clear();
                WidgetDescriptorRegistry.this._hashDescriptors.clear();
                try {
                    try {
                        long startTime = System.currentTimeMillis();
                        List projects = org.eclipse.edt.ide.core.internal.utils.Util.getEGLProjectPath((IProject)WidgetDescriptorRegistry.this._project, (boolean)false, (boolean)false);
                        for (EGLProject eglProject : projects) {
                            IProject project = eglProject.getProject();
                            WidgetDescriptorFactory factory = new WidgetDescriptorFactory(project);
                            IPart[] ruiWidgets = Util.searchForRUIWidgets((IProject)project);
                            int j = 0;
                            while (j < ruiWidgets.length) {
                                EGLFile file;
                                if (ruiWidgets[j] instanceof SourcePart) {
                                    file = (EGLFile)EGLCore.create((IResource)ruiWidgets[j].getResource());
                                    WidgetDescriptorRegistry.this.createWidgetDescriptor(factory, org.eclipse.edt.ide.core.internal.utils.Util.stringArrayToQualifiedName((String[])file.getPackageName()), file.getElementName(), ruiWidgets[j]);
                                } else if (ruiWidgets[j] instanceof BinaryPart) {
                                    file = (ClassFile)((BinaryPart)ruiWidgets[j]).getClassFile();
                                    IEGLElement parent = file.getParent();
                                    File eglarFile = null;
                                    while (!(parent instanceof EGLProject)) {
                                        if (parent instanceof EglarPackageFragmentRoot) {
                                            eglarFile = eglProject.getEGLPathEntryFor(parent.getPath()).getPath().toFile();
                                            break;
                                        }
                                        parent = parent.getParent();
                                    }
                                    WidgetDescriptorRegistry.this.createWidgetDescriptorFromEglar(factory, org.eclipse.edt.ide.core.internal.utils.Util.stringArrayToQualifiedName((String[])file.getPackageName()), file.getElementName(), ruiWidgets[j], eglarFile);
                                }
                                ++j;
                            }
                        }
                        Iterator iter = WidgetDescriptorRegistry.this._hashDescriptorGroups.values().iterator();
                        while (iter.hasNext()) {
                            ((WidgetDescriptorGroup)iter.next()).sortWidgets();
                        }
                        WidgetDescriptorRegistry.this._hashDataTemplateMappings.clear();
                        WidgetDescriptorRegistry.this.buildHashDataTemplateMapping();
                        WidgetDescriptorRegistry.this.debug("Finished initializing widget registry in " + (System.currentTimeMillis() - startTime) + "ms.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                int i = 0;
                                while (i < ((Updater)Updater.this).WidgetDescriptorRegistry.this._listListeners.size()) {
                                    IWidgetDescriptorRegistryListener listener = (IWidgetDescriptorRegistryListener)((Updater)Updater.this).WidgetDescriptorRegistry.this._listListeners.get(i);
                                    listener.widgetDescriptorRegistryChanged();
                                    ++i;
                                }
                            }
                        });
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }

        private class UpdaterSchedulingRule
        implements ISchedulingRule {
            private UpdaterSchedulingRule() {
            }

            public boolean contains(ISchedulingRule rule) {
                return this == rule;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule instanceof UpdaterSchedulingRule;
            }
        }
    }

    protected class UserUpdater
    extends Updater {
        public UserUpdater() {
            this.setUser(true);
            this.setSystem(false);
        }
    }
}

