/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.newvariable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfoRequestor;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.IPartNameRequestor;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.swt.graphics.Image;

public class NewEGLVariableWizardUtil {
    public static List<PartDeclarationInfo> getAvailableParts(IEGLProject project, DataType dataType) {
        int partType = 0;
        switch (dataType) {
            case Record: {
                partType = 8;
                break;
            }
            case DataItem: {
                return Collections.EMPTY_LIST;
            }
        }
        ArrayList<PartDeclarationInfo> partInfos = new ArrayList<PartDeclarationInfo>();
        try {
            IEGLProject[] projects = new IEGLProject[]{project};
            IEGLSearchScope searchScope = SearchEngine.createEGLSearchScope((IEGLElement[])projects, (boolean)true);
            PartInfoRequestor searchResult = new PartInfoRequestor(partInfos);
            new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), null, null, 2, false, partType, searchScope, (IPartNameRequestor)searchResult, 3, null);
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "Error processing to find parts ", (Throwable)e));
        }
        return NewEGLVariableWizardUtil.getFilterPartInfos(partInfos);
    }

    private static List<PartDeclarationInfo> getFilterPartInfos(List<PartDeclarationInfo> partInfos) {
        ArrayList<PartDeclarationInfo> results = new ArrayList<PartDeclarationInfo>();
        for (PartDeclarationInfo partInfo : partInfos) {
            if ("org.eclipse.edt.rui.widgets".equals(partInfo.getPackageName()) || "org.eclipse.edt.rui.mvc".equals(partInfo.getPackageName()) || "org.eclipse.edt.rui.infobus".equals(partInfo.getPackageName()) || "org.eclipse.edt.rui.history".equals(partInfo.getPackageName()) || "dojo.widgets".equals(partInfo.getPackageName())) continue;
            results.add(partInfo);
        }
        return results;
    }

    public static Image getImage(DataType dataType) {
        switch (dataType) {
            case Record: {
                return PluginImages.get((String)"org.eclipse.edt.ide.ui.record_obj.gif");
            }
            case DataItem: {
                return PluginImages.get((String)"org.eclipse.edt.ide.ui.dtaitm_obj.gif");
            }
        }
        return null;
    }

    public static enum DataType {
        Record,
        DataItem;

    }
}

