/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.edt.compiler.core.EGLKeywordHandler;
import org.eclipse.edt.compiler.internal.util.EGLMessage;

public class EGLNameValidator {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2000,2002\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PART = "Part";
    public static final String PROGRAM = "Program";
    public static final String PROGRAM_EXTERNAL_NAME = "Program external name";
    public static final String FUNCTION = "Function";
    public static final String RECORD_FILE_NAME = "Logical file name";
    public static final String RECORD = "Record";
    public static final String STRUCTURE = "Structure";
    public static final String TABLE = "Table";
    public static final String FORM = "Form";
    public static final String TABLE_EXTERNAL_NAME = "Table external name";
    public static final String DATAITEM = "DataItem";
    public static final String BUILD_DESCRIPTOR = "BuildDescriptor";
    public static final String LINKAGE_OPTIONS = "LinkageOptions";
    public static final String RESOURCE_ASSOCIATIONS = "ResourceAssociations";
    public static final String BIND_CONTROL = "BindControl";
    public static final String LINK_EDIT = "LinkEdit";
    public static final String TYPEDEF = "typeDef";
    public static final String TABLE_GENERATION = "table generation";
    public static final String SYMBOLIC_PARAMETER = "symbolicParameter";
    public static final String STATEMENT_ID = "statement ID";
    public static final int PART_LENGTH = 128;
    public static final int PROGRAM_LENGTH = 128;
    public static final int PROGRAM_EXTERNAL_NAME_LENGTH = 128;
    public static final int RECORD_FILE_NAME_LENGTH = 8;
    public static final int FUNCTION_LENGTH = 128;
    public static final int RECORD_LENGTH = 128;
    public static final int STRUCTURE_LENGTH = 128;
    public static final int FORM_LENGTH = 128;
    public static final int TABLE_LENGTH = 128;
    public static final int TABLE_EXTERNAL_NAME_LENGTH = 128;
    public static final int ITEM_LENGTH = 128;
    public static final int BUILD_DESCRIPTOR_LENGTH = 128;
    public static final int LINKAGE_OPTIONS_LENGTH = 128;
    public static final int RESOURCE_ASSOCIATIONS_LENGTH = 128;
    public static final int BIND_CONTROL_LENGTH = 128;
    public static final int LINK_EDIT_LENGTH = 128;
    public static final int TYPEDEF_LENGTH = 128;
    public static final int PARAMETER_LENGTH = 128;
    public static final int DECLARATION_LENGTH = 128;
    public static final int TABLE_GENERATION_LENGTH = 128;
    public static final int GLOBAL_IO_OBJECT_LENGTH = 128;
    public static final int SYMBOLIC_PARAMETER_LENGTH = 30;
    public static final int STATEMENT_ID_LENGTH = 128;
    public static final int PROJECT_ID_LENGTH = 44;
    private static Hashtable partNameLengths = new Hashtable();
    private static String[] RESERVED_WORDS;
    public static String[] keywords;

    static {
        partNameLengths.put(PART, new Integer(128));
        partNameLengths.put(PROGRAM, new Integer(128));
        partNameLengths.put(PROGRAM_EXTERNAL_NAME, new Integer(128));
        partNameLengths.put(FUNCTION, new Integer(128));
        partNameLengths.put(RECORD, new Integer(128));
        partNameLengths.put(RECORD_FILE_NAME, new Integer(8));
        partNameLengths.put(STRUCTURE, new Integer(128));
        partNameLengths.put(FORM, new Integer(128));
        partNameLengths.put(TABLE, new Integer(128));
        partNameLengths.put(TABLE_EXTERNAL_NAME, new Integer(128));
        partNameLengths.put(DATAITEM, new Integer(128));
        partNameLengths.put(BUILD_DESCRIPTOR, new Integer(128));
        partNameLengths.put(LINKAGE_OPTIONS, new Integer(128));
        partNameLengths.put(RESOURCE_ASSOCIATIONS, new Integer(128));
        partNameLengths.put(BIND_CONTROL, new Integer(128));
        partNameLengths.put(LINK_EDIT, new Integer(128));
        partNameLengths.put(TYPEDEF, new Integer(128));
        partNameLengths.put(TABLE_GENERATION, new Integer(128));
        partNameLengths.put(SYMBOLIC_PARAMETER, new Integer(30));
        partNameLengths.put(STATEMENT_ID, new Integer(128));
        RESERVED_WORDS = EGLKeywordHandler.getKeywordNames();
        keywords = EGLKeywordHandler.getKeywordNames();
    }

    private static String getResourceBundleName() {
        return "org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources";
    }

    public static boolean isJavaIdentifier(String candidate) {
        if (candidate == null || candidate.length() == 0 || !Character.isJavaIdentifierStart(candidate.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < candidate.length()) {
            if (!Character.isJavaIdentifierPart(candidate.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isJavaPackageName(String candidate) {
        if (candidate == null || candidate.length() == 0) {
            return false;
        }
        tokenizer = new StringTokenizer(candidate, ".", true);
        if (EGLNameValidator.isJavaIdentifier(tokenizer.nextToken())) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            tokenizer.nextToken();
            if (tokenizer.hasMoreTokens() && EGLNameValidator.isJavaIdentifier(tokenizer.nextToken())) continue;
            return false;
lbl10:
            // 2 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl11:
        // 1 sources

        return true;
    }

    public static boolean isKeyword(String name) {
        int i = 0;
        while (i < keywords.length) {
            if (keywords[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean startsWithEZE(String name) {
        if (name.length() < 3) {
            return false;
        }
        return name.toUpperCase().startsWith("EZE");
    }

    public static boolean strictValidateCharacters(String name) {
        if (name == null) {
            return false;
        }
        if (name == "") {
            return true;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isLetterOrDigit(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean validateCharacters(String name) {
        if (name == null) {
            return false;
        }
        if (name == "") {
            return true;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i)) && name.charAt(i) != '-') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean validateCharacters(String name, String nameType) {
        if (nameType == BUILD_DESCRIPTOR) {
            return true;
        }
        if (nameType == RECORD_FILE_NAME) {
            return EGLNameValidator.strictValidateCharacters(name);
        }
        return EGLNameValidator.validateCharacters(name);
    }

    public static ArrayList validateEGLName(String name, String nameType, Object targetObject) {
        ArrayList<EGLMessage> eglMessages = new ArrayList<EGLMessage>();
        if (name == null || name.equals("")) {
            return eglMessages;
        }
        if (nameType == null) {
            nameType = PART;
        }
        if (EGLNameValidator.isKeyword(name)) {
            eglMessages.add(EGLMessage.createEGLValidationErrorMessage((String)"3019", (Object)targetObject, (String[])new String[]{name}));
        }
        eglMessages.addAll(EGLNameValidator.validateEGLNameWithoutReservedValidation(name, nameType, targetObject));
        return eglMessages;
    }

    public static ArrayList validateEGLNameWithoutReservedValidation(String name, String nameType, Object targetObject) {
        ArrayList<EGLMessage> eglMessages = new ArrayList<EGLMessage>();
        if (name == null || name.equals("")) {
            return eglMessages;
        }
        if (nameType == null) {
            nameType = PART;
        }
        if (EGLNameValidator.startsWithEZE(name)) {
            eglMessages.add(EGLMessage.createEGLValidationErrorMessage((String)"3003", (Object)targetObject, (String[])new String[]{name}));
        }
        if (name.length() > (Integer)partNameLengths.get(nameType)) {
            eglMessages.add(EGLMessage.createEGLValidationErrorMessage((String)"3001", (Object)targetObject, (String[])new String[]{name, Integer.toString(name.length()), ((Integer)partNameLengths.get(nameType)).toString()}));
        }
        if (!EGLNameValidator.validateCharacters(name, nameType)) {
            eglMessages.add(EGLMessage.createEGLValidationErrorMessage((String)"3002", (Object)targetObject, (String[])new String[]{name}));
        }
        return eglMessages;
    }
}

