/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import java.util.List;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.ExceptionBlock;
import org.eclipse.edt.mof.egl.TryStatement;

public class TryStatementTemplate
extends JavaScriptTemplate {
    private static final String ANY_EXCEPTION = "eglx.lang.AnyException";
    private static final String JAVA_SCRIPT_OBJECT_EXCEPTION = "eglx.javascript.JavaScriptObjectException";

    public void genStatementBody(TryStatement stmt, Context ctx, TabbedWriter out) {
        out.print("try ");
        ctx.invoke("genStatement", (EObject)stmt.getTryBlock(), new Object[]{ctx, out});
        String exceptionVar = ctx.nextTempName();
        out.println("catch ( " + exceptionVar + " )");
        out.println("{");
        this.genCatchBlockBody(stmt, ctx, out, exceptionVar);
        out.println("}");
    }

    protected void genCatchBlockBody(TryStatement stmt, Context ctx, TabbedWriter out, String exceptionVar) {
        List exceptionBlocks = stmt.getExceptionBlocks();
        if (exceptionBlocks == null || exceptionBlocks.isEmpty()) {
            this.genCatchAllBlock(stmt, ctx, out, exceptionVar);
        } else {
            ExceptionBlock anyExceptionBlock = null;
            ExceptionBlock jsExceptionBlock = null;
            for (ExceptionBlock exceptionBlock : exceptionBlocks) {
                String sig = exceptionBlock.getException().getType().getTypeSignature();
                if (ANY_EXCEPTION.equals(sig)) {
                    anyExceptionBlock = exceptionBlock;
                    continue;
                }
                if (!JAVA_SCRIPT_OBJECT_EXCEPTION.equals(sig)) continue;
                jsExceptionBlock = exceptionBlock;
            }
            boolean genElse = false;
            for (ExceptionBlock exceptionBlock : exceptionBlocks) {
                if (exceptionBlock == anyExceptionBlock || exceptionBlock == jsExceptionBlock) continue;
                if (genElse) {
                    out.print("else ");
                }
                genElse = true;
                this.genException(exceptionBlock, ctx, out, exceptionVar);
            }
            if (jsExceptionBlock != null) {
                if (genElse) {
                    out.print("else ");
                }
                genElse = true;
                this.genException(jsExceptionBlock, ctx, out, exceptionVar);
            }
            if (anyExceptionBlock != null) {
                if (genElse) {
                    out.print("else ");
                }
                genElse = true;
                this.genException(anyExceptionBlock, ctx, out, exceptionVar);
            } else {
                out.println("else {");
                out.println("throw " + exceptionVar + ";");
                out.println("}");
            }
        }
    }

    protected void genCatchAllBlock(TryStatement stmt, Context ctx, TabbedWriter out, String exceptionVar) {
    }

    public void genException(ExceptionBlock exceptionBlock, Context ctx, TabbedWriter out, String exceptionVar) {
        this.genCatchBody(exceptionBlock, ctx, out, exceptionVar);
    }

    protected void genCatchBody(ExceptionBlock exceptionBlock, Context ctx, TabbedWriter out, String exceptionVar) {
        String sig = exceptionBlock.getException().getType().getTypeSignature();
        if (JAVA_SCRIPT_OBJECT_EXCEPTION.equals(sig)) {
            out.println("if (" + exceptionVar + " instanceof egl.egl.javascript.JavaScriptObjectException || !(" + exceptionVar + " instanceof egl.egl.core.AnyException)) {");
            out.println("if (!(" + exceptionVar + " instanceof egl.egl.javascript.JavaScriptObjectException)) {");
            out.println(String.valueOf(exceptionVar) + " = egl.makeExceptionFromCaughtObject(" + exceptionVar + ");");
            out.println("}");
        } else if (ANY_EXCEPTION.equals(sig)) {
            out.println("{");
            out.println("if (!(" + exceptionVar + " instanceof egl.eglx.lang.AnyException)) {");
            out.println(String.valueOf(exceptionVar) + " = egl.makeExceptionFromCaughtObject(" + exceptionVar + ");");
            out.println("}");
        } else {
            out.println("if ( " + exceptionVar + " instanceof " + ctx.getNativeImplementationMapping(exceptionBlock.getException().getType()) + " ) {");
        }
        out.print("var ");
        ctx.invoke("genName", (EObject)exceptionBlock.getException(), new Object[]{ctx, out});
        out.println(" = " + exceptionVar + ";");
        ctx.invoke("genStatement", (EObject)exceptionBlock, new Object[]{ctx, out});
        out.println("}");
    }

    public void genStatementEnd(TryStatement stmt, Context ctx, TabbedWriter out) {
    }
}

