/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.services;

import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.Environment;

public class CommonUtilities {
    public static MemberName createMember(FunctionParameter parameter, Context ctx) {
        MemberName mn = ctx.getFactory().createMemberName();
        mn.setId(parameter.getCaseSensitiveName());
        mn.setMember((Member)parameter);
        return mn;
    }

    public static Function createProxyFunction(Function function, Context ctx) {
        Function proxy = (Function)function.clone();
        proxy.setName(CommonUtilities.createProxyFunctionName(proxy));
        CommonUtilities.addDelegateParameter(proxy, "ezeCallbackDelegate", ctx);
        CommonUtilities.addDelegateParameter(proxy, "ezeErrorCallbackDelegate", ctx);
        try {
            CommonUtilities.addParameter(proxy, "ezeHttp", (Type)Environment.getCurrentEnv().find("egl:eglx.http.IHttp"));
        }
        catch (Exception exception) {}
        return proxy;
    }

    private static void addDelegateParameter(Function proxy, String name, Context ctx) {
        CommonUtilities.addParameter(proxy, name, (Type)ctx.getFactory().createDelegate());
    }

    private static void addParameter(Function proxy, String name, Type type) {
        FunctionParameter param = JavaScriptTemplate.factory.createFunctionParameter();
        param.setIsNullable(true);
        param.setParameterKind(ParameterKind.PARM_IN);
        param.setName(name);
        param.setType(type);
        proxy.addParameter(param);
    }

    public static String createProxyFunctionName(Function function) {
        return "eze_" + function.getCaseSensitiveName() + "_Proxy";
    }
}

