/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.codemanipulation;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.ReturningToNameClause;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsOperation;
import org.eclipse.edt.mof.egl.Type;

public class OrganizeImportsVisitor
extends AbstractASTExpressionVisitor {
    private Name currentPartName = null;
    private OrganizeImportsOperation.OrganizedImportSection resolvedTypes;
    private Map unresolvedTypes;
    Set originalImports;
    private IProject project;

    public OrganizeImportsVisitor(OrganizeImportsOperation.OrganizedImportSection resolvedTypes, Map unresolvedTypes, Set oldImports, Boolean isIncludeRefFunc, IProject project) {
        this.resolvedTypes = resolvedTypes;
        this.unresolvedTypes = unresolvedTypes;
        this.originalImports = oldImports;
        this.project = project;
    }

    public void setCurrentPartName(Name partName) {
        this.currentPartName = partName;
    }

    public boolean visitExpression(Expression expression) {
        if (expression.isName()) {
            this.addUnresolvedName((Name)expression);
        }
        return true;
    }

    public boolean visit(CallStatement callStatement) {
        Expression invocationTarget = callStatement.getInvocationTarget();
        if (!invocationTarget.isName()) {
            Type binding = invocationTarget.resolveType();
            if (binding != null) {
                this.addToResovledTypes(binding);
            }
        } else {
            this.addUnresolvedName((Name)invocationTarget);
        }
        return true;
    }

    public boolean visit(AnnotationExpression annotationExpression) {
        this.addUnresolvedName(annotationExpression.getName());
        return true;
    }

    public boolean visit(SettingsBlock settingsBlock) {
        settingsBlock.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(Assignment assignment) {
                Expression lhsExp = assignment.getLeftHandSide();
                OrganizeImportsVisitor.this.visitExpression(lhsExp);
                return true;
            }
        });
        return true;
    }

    public boolean visit(Service service) {
        this.handlePart((Part)service);
        for (Name nextName : service.getImplementedInterfaces()) {
            this.addUnresolvedName(nextName);
        }
        return true;
    }

    public boolean visit(ExternalType externalType) {
        this.handlePart((Part)externalType);
        for (Name nextName : externalType.getExtendedTypes()) {
            this.addUnresolvedName(nextName);
        }
        return true;
    }

    public boolean visit(Record record) {
        this.handlePart((Part)record);
        return true;
    }

    public boolean visit(Handler handler) {
        this.handlePart((Part)handler);
        return true;
    }

    public boolean visit(Class eglClass) {
        this.handlePart((Part)eglClass);
        return true;
    }

    public boolean visit(Interface interfaceNode) {
        this.handlePart((Part)interfaceNode);
        return true;
    }

    public boolean visit(Library library) {
        this.handlePart((Part)library);
        return true;
    }

    public boolean visit(Program program) {
        this.handlePart((Part)program);
        return true;
    }

    private void handlePart(Part part) {
        Name subType = part.getSubType();
        if (subType != null) {
            this.addUnresolvedName(subType);
        }
    }

    public boolean visit(UseStatement useStatement) {
        for (Name nextName : useStatement.getNames()) {
            this.addUnresolvedName(nextName);
        }
        return true;
    }

    public boolean visit(ReturningToNameClause returningToNameClause) {
        this.addUnresolvedName(returningToNameClause.getName());
        return true;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        Expression expr = functionInvocation.getTarget();
        expr.accept((IASTVisitor)this);
        expr.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visitExpression(Expression expr) {
                if (expr.isName() && ((Name)expr).isSimpleName()) {
                    OrganizeImportsVisitor.this.addUnresolvedName((Name)expr);
                }
                return false;
            }
        });
        return true;
    }

    private void addUnresolvedName(Name nameNode) {
        Type binding = nameNode.resolveType();
        this.addToUnresolvedTypes(nameNode, binding);
    }

    private void addToUnresolvedTypes(Name nameNode, Type binding) {
        if (binding == null) {
            this.addToUnresolvedTypes(nameNode);
        }
    }

    public boolean visit(QualifiedName qualifiedName) {
        QualifiedName nameNode = qualifiedName;
        while (nameNode.isQualifiedName()) {
            nameNode = nameNode.getQualifier();
        }
        this.addUnresolvedName((Name)nameNode);
        return true;
    }

    public boolean visit(NameType nameType) {
        Type typeBinding = nameType.resolveType();
        this.addToUnresolvedTypes(nameType.getName(), typeBinding);
        return true;
    }

    public boolean visitName(Name name) {
        Type binding;
        if (name != this.currentPartName && (binding = name.resolveType()) != null) {
            this.addToResovledTypes(binding);
        }
        return true;
    }

    private void addToResovledTypes(Type typeBinding) {
        if (typeBinding instanceof org.eclipse.edt.mof.egl.Part) {
            org.eclipse.edt.mof.egl.Part classBinding = (org.eclipse.edt.mof.egl.Part)typeBinding;
            String partName = classBinding.getCaseSensitiveName();
            String packageName = classBinding.getCaseSensitivePackageName();
            if (!packageName.equalsIgnoreCase("eglx.lang") || this.isInOriginalImports(packageName, partName)) {
                this.resolvedTypes.addImport(packageName, partName);
            }
        }
    }

    private boolean isInOriginalImports(String pkgName2Test, String partName2Test) {
        boolean fndInOriginal = false;
        Iterator oldIt = this.originalImports.iterator();
        while (oldIt.hasNext() && !fndInOriginal) {
            ImportDeclaration oldImportDecl = (ImportDeclaration)oldIt.next();
            Name importNameNode = oldImportDecl.getName();
            String oldPackageName = "";
            if (!oldImportDecl.isOnDemand()) {
                String oldPartName = importNameNode.getIdentifier();
                if (!partName2Test.equalsIgnoreCase(oldPartName)) continue;
                if (importNameNode instanceof QualifiedName) {
                    oldPackageName = ((QualifiedName)importNameNode).getQualifier().getCanonicalName();
                }
                if (!oldPackageName.equalsIgnoreCase(pkgName2Test)) continue;
                fndInOriginal = true;
                continue;
            }
            oldPackageName = importNameNode.getCanonicalName();
            if (!pkgName2Test.equalsIgnoreCase(oldPackageName)) continue;
            fndInOriginal = true;
        }
        return fndInOriginal;
    }

    private void addToUnresolvedTypes(Name name) {
        this.addToMapTypes(name, this.unresolvedTypes);
    }

    private void addToMapTypes(Name name, Map types) {
        String strname = name.getIdentifier();
        if (!types.containsKey(strname)) {
            types.put(strname, name);
        }
    }
}

