/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseBlock;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBindingBlock;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDeploymentDescriptorEditor;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.dialogs.EGLPartSelectionDialog;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class EGLDDBindingFormPage
extends EGLDDBaseFormPage {
    private EGLDDBaseBlock block = new EGLDDBindingBlock(this);

    public EGLDDBindingFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.block.formPageActive();
        }
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(SOAMessages.BindingFormPageTitle);
        EGLDeploymentRoot eglDDRoot = this.getModelRoot();
        managedForm.setInput((Object)eglDDRoot);
        this.block.createContent(managedForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), this.getHelpID());
    }

    public EGLPartSelectionDialog getEGLPartSelectionDialog(int elemKind, String title, String message, final String helpId) {
        Shell shell = this.getSite().getShell();
        EGLFileConfiguration fileConfig = new EGLFileConfiguration();
        IWorkbenchWindow workbenchwin = this.getSite().getWorkbenchWindow();
        EGLDeploymentDescriptorEditor eglddEditor = (EGLDeploymentDescriptorEditor)this.getEditor();
        IProject project = eglddEditor.getProject();
        IEGLProject eglProj = EGLCore.create((IProject)project);
        IEGLSearchScope projSearchScope = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLElement[]{eglProj}, (boolean)true);
        EGLPartSelectionDialog dialog = new EGLPartSelectionDialog(shell, (IRunnableContext)workbenchwin, elemKind, "", null, projSearchScope, fileConfig){

            public Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                if (helpId != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(control, helpId);
                }
                return control;
            }
        };
        dialog.setTitle(title);
        dialog.setMessage(message);
        return dialog;
    }

    public void refreshBlockTableViewer() {
        this.block.refreshTableViewer();
    }

    public boolean selectReveal(Object object) {
        this.block.selectTableElement((ISelection)object);
        return super.selectReveal(object);
    }

    @Override
    protected String getHelpID() {
        return IUIHelpConstants.EGLDD_EDITOR_BINDINGPAGE;
    }
}

