/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.edt.ide.ui.internal.editor.ClassFileMarkerAnnotationModel;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.editor.EGLMarkerAnnotationModel;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;

public class BinaryFileDocumentProvider
extends DocumentProvider {
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof BinaryEditorInput) {
            BinaryEditorInput eglfile = (BinaryEditorInput)editorInput;
            String source = eglfile.getSource();
            if (source == null) {
                source = "";
            }
            document.set(source);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    @Override
    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof BinaryEditorInput) {
            BinaryEditorInput input = (BinaryEditorInput)element;
            if (input.getClassFile() != null) {
                return new ClassFileMarkerAnnotationModel((IResource)input.getBinaryReadOnlyFile(), input.getClassFile());
            }
            return new EGLMarkerAnnotationModel((IResource)input.getBinaryReadOnlyFile());
        }
        return super.createAnnotationModel(element);
    }
}

