/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.compiler.internal.eglar.EglarManifest;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarOutputStream;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageData;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerMessages;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerUtil;
import org.eclipse.edt.ide.ui.internal.property.pages.BasicElementLabels;
import org.eclipse.edt.ide.ui.internal.property.pages.Messages;
import org.eclipse.swt.widgets.Shell;

public class EglarWriterUtility {
    private Set fDirectories = new HashSet();
    private EglarOutputStream fEglarOutputStream;
    private EglarPackageData fEglarPackage;

    public EglarWriterUtility(EglarPackageData eglarPackage, Shell parent) throws CoreException {
        Assert.isNotNull((Object)eglarPackage, (String)"The Eglar specification is null");
        this.fEglarPackage = eglarPackage;
        Assert.isTrue((boolean)this.fEglarPackage.isValid(), (String)"The EGLAR or binary project specification is invalid");
        if (!this.canCreateEglar(parent)) {
            throw new OperationCanceledException();
        }
        try {
            this.fEglarOutputStream = new EglarOutputStream(new BufferedOutputStream(new FileOutputStream(this.fEglarPackage.getAbsoluteEglarLocation().toFile())));
            String comment = eglarPackage.getComment();
            if (comment != null) {
                this.fEglarOutputStream.setComment(comment);
            }
        }
        catch (IOException exception) {
            throw EglarPackagerUtil.createCoreException(exception.getLocalizedMessage(), exception);
        }
    }

    public EglarWriterUtility(EglarOutputStream eglarOutputStream, Shell parent) {
        this.fEglarOutputStream = eglarOutputStream;
    }

    protected void addDirectories(IPath destinationPath) throws IOException {
        this.addDirectories(destinationPath.toString());
    }

    protected void addDirectories(String destPath) throws IOException {
        String path = destPath.replace(File.separatorChar, '/');
        int lastSlash = path.lastIndexOf(47);
        ArrayList<JarEntry> directories = new ArrayList<JarEntry>(2);
        while (lastSlash != -1) {
            if (!this.fDirectories.add(path = path.substring(0, lastSlash + 1))) break;
            JarEntry newEntry = new JarEntry(path);
            newEntry.setMethod(0);
            newEntry.setSize(0L);
            newEntry.setCrc(0L);
            newEntry.setTime(System.currentTimeMillis());
            directories.add(newEntry);
            lastSlash = path.lastIndexOf(47, lastSlash - 1);
        }
        int i = directories.size() - 1;
        while (i >= 0) {
            this.fEglarOutputStream.putNextEntry((JarEntry)directories.get(i));
            --i;
        }
    }

    protected void addDirectories(IResource resource, IPath destinationPath) throws IOException, CoreException {
        IContainer parent = null;
        String path = destinationPath.toString().replace(File.separatorChar, '/');
        int lastSlash = path.lastIndexOf(47);
        ArrayList<JarEntry> directories = new ArrayList<JarEntry>(2);
        while (lastSlash != -1) {
            IFileInfo info;
            if (!this.fDirectories.add(path = path.substring(0, lastSlash + 1))) break;
            parent = resource.getParent();
            long timeStamp = System.currentTimeMillis();
            URI location = parent.getLocationURI();
            if (location != null && (info = EFS.getStore((URI)location).fetchInfo()).exists()) {
                timeStamp = info.getLastModified();
            }
            JarEntry newEntry = new JarEntry(path);
            newEntry.setMethod(0);
            newEntry.setSize(0L);
            newEntry.setCrc(0L);
            newEntry.setTime(timeStamp);
            directories.add(newEntry);
            lastSlash = path.lastIndexOf(47, lastSlash - 1);
        }
        int i = directories.size() - 1;
        while (i >= 0) {
            this.fEglarOutputStream.putNextEntry((JarEntry)directories.get(i));
            --i;
        }
    }

    protected void addFile(IFile resource, IPath path) throws IOException, CoreException {
        IFileInfo info;
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        byte[] readBuffer = new byte[4096];
        if (this.fEglarPackage == null) {
            newEntry.setMethod(8);
        } else if (this.fEglarPackage.isCompressed()) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            EglarPackagerUtil.calculateCrcAndSize(newEntry, resource.getContents(false), readBuffer);
        }
        long lastModified = System.currentTimeMillis();
        URI locationURI = resource.getLocationURI();
        if (locationURI != null && (info = EFS.getStore((URI)locationURI).fetchInfo()).exists()) {
            lastModified = info.getLastModified();
        }
        newEntry.setTime(lastModified);
        InputStream contentStream = resource.getContents(false);
        this.addEntry(newEntry, contentStream);
    }

    protected void addFileByBytes(byte[] bytes, IPath path) throws CoreException {
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        newEntry.setMethod(8);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(bytes);
        try {
            this.addEntry(newEntry, contentStream);
        }
        catch (IOException e) {
            EglarWriterUtility.handleGeneralEglarException(path, e);
        }
    }

    public void addManifest(EglarManifest eglarManifest) throws IOException {
        this.fEglarOutputStream.addManEntry(eglarManifest);
    }

    protected void addEntry(JarEntry entry, InputStream content) throws IOException {
        byte[] readBuffer = new byte[4096];
        try {
            int count;
            this.fEglarOutputStream.putNextEntry(entry);
            while ((count = content.read(readBuffer, 0, readBuffer.length)) != -1) {
                this.fEglarOutputStream.write(readBuffer, 0, count);
            }
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }

    protected boolean canCreateEglar(Shell parent) {
        File file = this.fEglarPackage.getAbsoluteEglarLocation().toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fEglarPackage.isBinaryProjectExport() || this.fEglarPackage.allowOverwrite()) {
                return true;
            }
            return parent != null && EglarPackagerUtil.askForOverwritePermission(parent, this.fEglarPackage.getAbsoluteEglarLocation(), true);
        }
        String path = file.getAbsolutePath();
        int separatorIndex = path.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        File directory = new File(path.substring(0, separatorIndex + 1));
        if (!directory.exists()) {
            if (this.fEglarPackage.isBinaryProjectExport() || EglarPackagerUtil.askToCreateDirectory(parent, directory)) {
                return directory.mkdirs();
            }
            return false;
        }
        return true;
    }

    public void close() throws CoreException {
        try {
            if (this.fEglarOutputStream != null) {
                this.fEglarOutputStream.close();
            }
            this.registerInWorkspaceIfNeeded();
        }
        catch (IOException ex) {
            throw EglarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    private void registerInWorkspaceIfNeeded() {
        IPath eglarPath = this.fEglarPackage.getAbsoluteEglarLocation();
        this.refresh(eglarPath);
        this.refresh(this.fEglarPackage.getAbsoluteEglarSrcLocation());
    }

    private void refresh(IPath path) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf(path)) {
                try {
                    path = path.removeFirstSegments(projectLocation.segmentCount());
                    path = path.removeLastSegments(1);
                    IResource containingFolder = project.findMember(path);
                    if (containingFolder != null && containingFolder.isAccessible()) {
                        containingFolder.refreshLocal(1, null);
                    }
                }
                catch (CoreException ex) {
                    EDTUIPlugin.log(ex);
                }
            }
            ++i;
        }
    }

    public void write(IFile resource, IPath destinationPath) throws CoreException {
        try {
            if (this.fEglarPackage.areDirectoryEntriesIncluded()) {
                this.addDirectories((IResource)resource, destinationPath);
            }
            this.addFile(resource, destinationPath);
        }
        catch (IOException ex) {
            EglarWriterUtility.handleGeneralEglarException(resource.getFullPath(), ex);
        }
    }

    public static void handleGeneralEglarException(IPath path, Exception ex) throws CoreException {
        String message = null;
        message = ex.getLocalizedMessage() != null ? Messages.format(EglarPackagerMessages.EglarWriter_writeProblemWithMessage, new Object[]{BasicElementLabels.getPathLabel(path, false), ex.getLocalizedMessage()}) : Messages.format(EglarPackagerMessages.EglarWriter_writeProblem, BasicElementLabels.getPathLabel(path, false));
        throw EglarPackagerUtil.createCoreException(message, ex);
    }
}

