/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.util.Locale;
import java.util.Map;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.EGLSourceViewer;
import org.eclipse.edt.ide.ui.internal.editor.EGLSourceViewerConfiguration;
import org.eclipse.edt.ide.ui.internal.editor.TextTools;
import org.eclipse.edt.ide.ui.internal.formatting.CodeFormatterConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class EGLPreview {
    private String fPreviewText;
    protected final EGLSourceViewerConfiguration fViewerConfiguration;
    protected final Document fPreviewDocument;
    protected final SourceViewer fSourceViewer;
    protected final IPreferenceStore fPreferenceStore;
    protected final MarginPainter fMarginPainter;
    private Map fPreferenceSetting;
    private int fTabSize = 0;
    private TextTools ftools;

    public EGLPreview(Composite parent, Map preferenceSetting) {
        this.fPreferenceSetting = preferenceSetting;
        this.ftools = new TextTools(EDTUIPlugin.getDefault().getPreferenceStore());
        this.fPreviewDocument = new Document();
        this.ftools.setupEGLDocumentPartitioner((IDocument)this.fPreviewDocument);
        IPreferenceStore[] chain = new IPreferenceStore[]{EDTUIPlugin.getDefault().getPreferenceStore()};
        this.fPreferenceStore = new ChainedPreferenceStore(chain);
        int styles = 2824;
        if (Locale.getDefault().toString().toLowerCase().indexOf("ar") != -1) {
            styles |= 0x2000000;
        }
        this.fSourceViewer = new EGLSourceViewer(parent, null, null, false, styles);
        this.fViewerConfiguration = new EGLSourceViewerConfiguration(this.ftools);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.edt.ide.ui.editors.textfont"));
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fSourceViewer);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
        this.fMarginPainter.setMarginRulerColor(this.ftools.getEGLColorProvider().getColorForRGB(rgb));
        this.fSourceViewer.addPainter((IPainter)this.fMarginPainter);
        new EGLSourcePreviewerUpdater();
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void update() {
        int lineWidth = CodeFormatterConstants.getIntPreferenceSetting(this.fPreferenceSetting, "lineWrapping.maxLineWidth");
        this.fMarginPainter.setMarginRulerColumn(lineWidth);
        int tabSize = CodeFormatterConstants.getIntPreferenceSetting(this.fPreferenceSetting, "generalSettings.indentationSize");
        if (tabSize != this.fTabSize) {
            this.fSourceViewer.getTextWidget().setTabs(tabSize);
        }
        this.fTabSize = tabSize;
        StyledText widget = (StyledText)this.fSourceViewer.getControl();
        int height = widget.getClientArea().height;
        int top0 = widget.getTopPixel();
        int totalPixels0 = this.getHeightOfAllLines(widget);
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        widget.setRedraw(false);
        this.doFormatPreview();
        this.fSourceViewer.setSelection(null);
        int totalPixels1 = this.getHeightOfAllLines(widget);
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        widget.setTopPixel(top1);
        widget.setRedraw(true);
    }

    protected void doFormatPreview() {
        this.fPreviewDocument.set(this.fPreviewText);
        this.fSourceViewer.setRedraw(false);
        FormattingContext context = new FormattingContext();
        try {
            IContentFormatter formatter = this.fViewerConfiguration.getContentFormatter((ISourceViewer)this.fSourceViewer);
            if (formatter instanceof IContentFormatterExtension) {
                IContentFormatterExtension extension = (IContentFormatterExtension)formatter;
                context.setProperty((Object)"formatting.context.preferences", (Object)this.fPreferenceSetting);
                context.setProperty((Object)"formatting.context.document", (Object)true);
                extension.format((IDocument)this.fPreviewDocument, (IFormattingContext)context);
            }
        }
        finally {
            this.fSourceViewer.setRedraw(true);
        }
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int height = 0;
        int lineCount = styledText.getLineCount();
        int i = 0;
        while (i < lineCount) {
            height += styledText.getLineHeight(styledText.getOffsetAtLine(i));
            ++i;
        }
        return height;
    }

    private static int getPositiveIntValue(String string, int defaultValue) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return defaultValue;
    }

    public void setPreviewText(String previewText) {
        this.fPreviewText = previewText;
        this.update();
    }

    public String getDefaultLineDelimiter() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.fPreviewDocument);
    }

    public void dispose() {
        if (this.ftools != null) {
            this.ftools.dispose();
        }
    }

    private final class EGLSourcePreviewerUpdater {
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.edt.ide.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.eclipse.edt.ide.ui.editors.textfont");
                    ((EGLSourcePreviewerUpdater)EGLSourcePreviewerUpdater.this).EGLPreview.this.fSourceViewer.getTextWidget().setFont(font);
                    if (((EGLSourcePreviewerUpdater)EGLSourcePreviewerUpdater.this).EGLPreview.this.fMarginPainter != null) {
                        ((EGLSourcePreviewerUpdater)EGLSourcePreviewerUpdater.this).EGLPreview.this.fMarginPainter.initialize();
                    }
                }
            }
        };
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ((EGLSourcePreviewerUpdater)EGLSourcePreviewerUpdater.this).EGLPreview.this.fSourceViewer.invalidateTextPresentation();
            }
        };

        public EGLSourcePreviewerUpdater() {
            JFaceResources.getFontRegistry().addListener(this.fontListener);
            EGLPreview.this.fPreferenceStore.addPropertyChangeListener(this.propertyListener);
            EGLPreview.this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener(EGLSourcePreviewerUpdater.this.fontListener);
                    ((EGLSourcePreviewerUpdater)EGLSourcePreviewerUpdater.this).EGLPreview.this.fPreferenceStore.removePropertyChangeListener(EGLSourcePreviewerUpdater.this.propertyListener);
                }
            });
        }
    }
}

