/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.property.pages;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusUtil;
import org.eclipse.edt.ide.ui.internal.property.pages.ArchiveFileFilter;
import org.eclipse.edt.ide.ui.internal.property.pages.BasicElementLabels;
import org.eclipse.edt.ide.ui.internal.property.pages.EGLARFileSelectionDialog;
import org.eclipse.edt.ide.ui.internal.property.pages.Messages;
import org.eclipse.edt.ide.ui.internal.property.pages.VariablePathDialogField;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.edt.ide.ui.internal.wizards.FolderSelectionDialog;
import org.eclipse.edt.ide.ui.internal.wizards.IStatusChangeListener;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SourceAttachmentBlock {
    private final IStatusChangeListener fContext;
    private StringButtonDialogField fFileNameField;
    private SelectionButtonDialogField fWorkspaceButton;
    private IStatus fNameStatus;
    private IPath fFileVariablePath;
    private final IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTWidget;
    private Label fFullPathResolvedLabel;
    private IEGLProject fProject;
    private final IEGLPathEntry fEntry;

    public SourceAttachmentBlock(IStatusChangeListener context, IEGLPathEntry entry) {
        Assert.isNotNull((Object)entry);
        this.fContext = context;
        this.fEntry = entry;
        int kind = entry.getEntryKind();
        Assert.isTrue((kind == 1 || kind == 4 ? 1 : 0) != 0);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fNameStatus = new StatusInfo();
        SourceAttachmentAdapter adapter = new SourceAttachmentAdapter();
        if (this.isVariableEntry()) {
            this.fFileNameField = new VariablePathDialogField(adapter);
            this.fFileNameField.setDialogFieldListener(adapter);
            this.fFileNameField.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_varlabel);
            this.fFileNameField.setButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_external_varbutton);
            ((VariablePathDialogField)this.fFileNameField).setVariableButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_variable_button);
        } else {
            this.fFileNameField = new StringButtonDialogField(adapter);
            this.fFileNameField.setDialogFieldListener(adapter);
            this.fFileNameField.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_label);
            this.fFileNameField.setButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_externalfile_button);
            this.fWorkspaceButton = new SelectionButtonDialogField(8);
            this.fWorkspaceButton.setDialogFieldListener(adapter);
            this.fWorkspaceButton.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_internal_button);
        }
        this.setDefaults();
    }

    public void setDefaults() {
        if (this.fEntry.getSourceAttachmentPath() != null) {
            this.fFileNameField.setText(this.fEntry.getSourceAttachmentPath().toString());
        } else {
            this.fFileNameField.setText("");
        }
    }

    private boolean isVariableEntry() {
        return this.fEntry.getEntryKind() == 4;
    }

    public IPath getSourceAttachmentPath() {
        if (this.fFileNameField.getText().length() == 0) {
            return null;
        }
        return this.getFilePath();
    }

    public IPath getSourceAttachmentRootPath() {
        return null;
    }

    public IEGLPathEntry getNewEntry() {
        PPListElement elem = PPListElement.createFromExisting((IEGLPathEntry)this.fEntry, (IEGLProject)this.fProject);
        elem.setAttribute("sourcepath", (Object)this.getSourceAttachmentPath());
        return elem.getEGLPathEntry();
    }

    public Control createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        if (this.isVariableEntry()) {
            int widthHint = converter.convertWidthInCharsToPixels(40);
            int labelWidthHint = widthHint * 2;
            Label message = new Label(composite, 64);
            GridData gd = new GridData(4, 1, false, false, 4, 1);
            message.setLayoutData((Object)gd);
            message.setText(Messages.format(NewWizardMessages.SourceAttachmentBlock_message, BasicElementLabels.getResourceName(this.fEntry.getPath().lastSegment())));
            Label desc = new Label(composite, 64);
            gd = new GridData(4, 1, false, false, 4, 1);
            gd.widthHint = labelWidthHint;
            desc.setLayoutData((Object)gd);
            desc.setText(NewWizardMessages.SourceAttachmentBlock_filename_description);
            this.fFileNameField.doFillIntoGrid(composite, 4);
            LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), widthHint);
            this.fFullPathResolvedLabel = new Label(composite, 64);
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
            gd = new GridData(4, 1, false, false, 4, 1);
            gd.widthHint = labelWidthHint;
            this.fFullPathResolvedLabel.setLayoutData((Object)gd);
            LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        } else {
            int widthHint = converter.convertWidthInCharsToPixels(60);
            GridData gd = new GridData(4, 1, false, false, 3, 1);
            gd.widthHint = converter.convertWidthInCharsToPixels(50);
            Label message = new Label(composite, 16448);
            message.setLayoutData((Object)gd);
            message.setText(Messages.format(NewWizardMessages.SourceAttachmentBlock_message, BasicElementLabels.getResourceName(this.fEntry.getPath().lastSegment())));
            this.fWorkspaceButton.doFillIntoGrid(composite, 1);
            ((GridData)this.fWorkspaceButton.getSelectionButton(null).getLayoutData()).verticalAlignment = 0x1000008;
            this.fFileNameField.doFillIntoGrid(composite, 4);
            LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), widthHint);
            LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
            DialogField.createEmptySpace(composite, 3);
        }
        this.fFileNameField.postSetFocusOnDialogField(parent.getDisplay());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void attachmentChangeControlPressed(DialogField field) {
        if (field == this.fFileNameField) {
            IPath jarFilePath;
            IPath iPath = jarFilePath = this.isVariableEntry() ? this.chooseExtension() : this.chooseExtJarFile();
            if (jarFilePath != null) {
                this.fFileNameField.setText(jarFilePath.toString());
            }
        }
    }

    private void attachmentDialogFieldChanged(DialogField field) {
        if (field == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        } else if (field == this.fWorkspaceButton) {
            IPath jarFilePath = this.chooseInternal();
            if (jarFilePath != null) {
                this.fFileNameField.setText(jarFilePath.toString());
            }
            return;
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fNameStatus});
        this.fContext.statusChanged(status);
    }

    private boolean canBrowseFileName() {
        if (!this.isVariableEntry()) {
            return true;
        }
        if (this.fFileVariablePath != null) {
            return this.fFileVariablePath.toFile().isDirectory();
        }
        return false;
    }

    private String getResolvedLabelString() {
        IPath resolvedPath = this.getResolvedPath(this.getFilePath());
        if (resolvedPath != null) {
            return BasicElementLabels.getPathLabel(resolvedPath, true);
        }
        return "";
    }

    private IPath getResolvedPath(IPath path) {
        IPath varPath;
        String varName;
        if (path != null && (varName = path.segment(0)) != null && (varPath = EGLCore.getEGLPathVariable((String)varName)) != null) {
            return varPath.append(path.removeFirstSegments(1));
        }
        return null;
    }

    private IStatus updateFileNameStatus() {
        StatusInfo status = new StatusInfo();
        this.fFileVariablePath = null;
        String fileName = this.fFileNameField.getText();
        if (fileName.length() == 0) {
            return status;
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            status.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_notvalid);
            return status;
        }
        IPath filePath = Path.fromOSString((String)fileName);
        if (this.isVariableEntry()) {
            if (filePath.getDevice() != null) {
                status.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_deviceinpath);
                return status;
            }
            String varName = filePath.segment(0);
            if (varName == null) {
                status.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_notvalid);
                return status;
            }
            this.fFileVariablePath = EGLCore.getEGLPathVariable((String)varName);
            if (this.fFileVariablePath == null) {
                status.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_varnotexists);
                return status;
            }
            IPath resolvedPath = this.fFileVariablePath.append(filePath.removeFirstSegments(1));
            if (resolvedPath.isEmpty()) {
                status.setWarning(NewWizardMessages.SourceAttachmentBlock_filename_warning_varempty);
                return status;
            }
            File file = resolvedPath.toFile();
            if (!file.exists()) {
                String message = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_filenotexists, BasicElementLabels.getPathLabel(resolvedPath, true));
                status.setWarning(message);
                return status;
            }
            if (!resolvedPath.isAbsolute()) {
                String message = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_notabsolute, BasicElementLabels.getPathLabel(filePath, false));
                status.setError(message);
                return status;
            }
        } else {
            File file = filePath.toFile();
            IResource res = this.fWorkspaceRoot.findMember(filePath);
            if (res != null && res.getLocation() != null) {
                file = res.getLocation().toFile();
            }
            if (!file.exists()) {
                String message = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_filenotexists, BasicElementLabels.getPathLabel(filePath, false));
                status.setError(message);
                return status;
            }
            if (res == null && !filePath.isAbsolute()) {
                String message = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_notabsolute, BasicElementLabels.getPathLabel(filePath, false));
                status.setError(message);
                return status;
            }
        }
        return status;
    }

    private IPath getFilePath() {
        return Path.fromOSString((String)this.fFileNameField.getText()).makeAbsolute();
    }

    private IPath chooseExtension() {
        IPath resolvedPath;
        IPath currPath = this.getFilePath();
        if (currPath.segmentCount() == 0) {
            currPath = this.fEntry.getPath();
        }
        File initialSelection = (resolvedPath = this.getResolvedPath(currPath)) != null ? resolvedPath.toFile() : null;
        String currVariable = currPath.segment(0);
        EGLARFileSelectionDialog dialog = new EGLARFileSelectionDialog(this.getShell(), false, true, false);
        dialog.setTitle(NewWizardMessages.SourceAttachmentBlock_extvardialog_title);
        dialog.setMessage(NewWizardMessages.SourceAttachmentBlock_extvardialog_description);
        dialog.setInput(this.fFileVariablePath.toFile());
        dialog.setInitialSelection(initialSelection);
        if (dialog.open() == 0) {
            File result = (File)dialog.getResult()[0];
            IPath returnPath = Path.fromOSString((String)result.getPath()).makeAbsolute();
            return this.modifyPath(returnPath, currVariable);
        }
        return null;
    }

    private IPath chooseExtJarFile() {
        IPath currPath = this.getFilePath();
        if (currPath.segmentCount() == 0) {
            currPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath(currPath, true)) {
            currPath = currPath.removeLastSegments(1);
        }
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(NewWizardMessages.SourceAttachmentBlock_exteglardialog_text);
        dialog.setFilterExtensions(ArchiveFileFilter.EGLAR_SOURCE_ATTACHMENT_FILTER_EXTENSIONS);
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return Path.fromOSString((String)res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseInternal() {
        String initSelection = this.fFileNameField.getText();
        ArchiveFileFilter filter = new ArchiveFileFilter(null, false);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSel = null;
        if (initSelection.length() > 0) {
            initSel = this.fWorkspaceRoot.findMember((IPath)new Path(initSelection));
        }
        if (initSel == null) {
            initSel = this.fWorkspaceRoot.findMember(this.fEntry.getPath());
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setAllowMultiple(false);
        dialog.addFilter(filter);
        dialog.setTitle(NewWizardMessages.SourceAttachmentBlock_integlardialog_title);
        dialog.setMessage(NewWizardMessages.SourceAttachmentBlock_integlardialog_message);
        dialog.setInput(this.fWorkspaceRoot);
        dialog.setInitialSelection(initSel);
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            return res.getFullPath();
        }
        return null;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return EDTUIPlugin.getActiveWorkbenchShell();
    }

    private IPath modifyPath(IPath path, String varName) {
        if (varName == null || path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return new Path(varName);
        }
        IPath varPath = EGLCore.getEGLPathVariable((String)varName);
        path = varPath != null ? (varPath.isPrefixOf(path) ? path.removeFirstSegments(varPath.segmentCount()) : new Path(path.lastSegment())) : new Path(path.lastSegment());
        return new Path(varName).append(path);
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceAttachmentAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            SourceAttachmentBlock.this.attachmentChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            SourceAttachmentBlock.this.attachmentDialogFieldChanged(field);
        }
    }
}

