/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion.sqldb;

import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.edt.gen.generator.eglsource.EglSourceContext;
import org.eclipse.edt.ide.ui.internal.dataaccess.conversion.sqldb.DataToolsSqlTemplate;

public class DataToolsSqlTableTemplate
extends DataToolsSqlTemplate {
    public void genTable(Table table, EglSourceContext ctx) {
        Object[] columns;
        ctx.appendVariableValue("recordFileContent", this.getEntityRecordHeader(table, ctx), "");
        Object[] objectArray = columns = table.getColumns().toArray();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            Object column = objectArray[n2];
            ctx.invoke("genColumn", column, new Object[]{ctx});
            ++n2;
        }
        ctx.appendVariableValue("recordFileContent", this.getRecordFooter(), "");
    }

    public void genObject(Table object, EglSourceContext ctx) {
        if (object instanceof Table) {
            this.genTable(object, ctx);
        }
    }

    public String getEntityRecordName(Table table) {
        String name = this.getValidName(table).toLowerCase();
        char[] arr = name.toCharArray();
        int i = 0;
        while (i < arr.length) {
            if (Character.isLetter(arr[i])) {
                arr[i] = Character.toUpperCase(arr[i]);
                break;
            }
            ++i;
        }
        return String.valueOf(arr);
    }

    public String getValidName(Table table) {
        String aliasName = this.getAliasName(table.getName());
        return aliasName == null ? table.getName() : aliasName;
    }

    public String getEntityRecordHeader(Table table, EglSourceContext ctx) {
        StringBuffer s = new StringBuffer(200);
        s.append("record " + this.getEntityRecordName(table) + " type Entity ");
        boolean isTableQualified = (Boolean)ctx.get((Object)"tableNameQualified");
        if (isTableQualified) {
            s.append("{ @table { name=\"" + table.getSchema().getName() + "." + table.getName() + "\" } }");
        } else {
            s.append("{ @table { name=\"" + table.getName() + "\" } }");
        }
        return s.toString();
    }

    public String getRecordFooter() {
        return "\nend\n";
    }
}

