/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenameInputWizardPage;
import org.eclipse.edt.ide.ui.internal.refactoring.tagging.INameUpdating;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;

public class RenameRefactoringWizard
extends RefactoringWizard {
    private final String fInputPageDescription;
    private final String fPageContextHelpId;

    public RenameRefactoringWizard(Refactoring refactoring, String defaultPageTitle, String inputPageDescription, String pageContextHelpId) {
        super(refactoring, 4);
        this.setDefaultPageTitle(defaultPageTitle);
        this.fInputPageDescription = inputPageDescription;
        this.fPageContextHelpId = pageContextHelpId;
    }

    protected void addUserInputPages() {
        String initialSetting = this.getNameUpdating().getCurrentElementName();
        RenameInputWizardPage inputPage = this.createInputPage(this.fInputPageDescription, initialSetting);
        this.addPage((IWizardPage)inputPage);
    }

    private INameUpdating getNameUpdating() {
        return (INameUpdating)this.getRefactoring().getAdapter(INameUpdating.class);
    }

    protected RenameInputWizardPage createInputPage(String message, String initialSetting) {
        return new RenameInputWizardPage(message, this.fPageContextHelpId, true, initialSetting){

            @Override
            protected RefactoringStatus validateTextField(String text) {
                return RenameRefactoringWizard.this.validateNewName(text);
            }
        };
    }

    protected RefactoringStatus validateNewName(String newName) {
        INameUpdating ref = this.getNameUpdating();
        ref.setNewElementName(newName);
        try {
            return ref.checkNewElementName(newName);
        }
        catch (CoreException e) {
            EDTUIPlugin.log(e);
            return RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.Refactor_unexpected_exception);
        }
    }
}

