/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchQuery;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class EGLSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private final Match[] EMPTY_ARR = new Match[0];
    private EGLSearchQuery fQuery;

    public EGLSearchResult(EGLSearchQuery job) {
        this.fQuery = job;
    }

    public Match[] findContainedMatches(IFile file) {
        return this.getMatches(file);
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            FileEditorInput fi = (FileEditorInput)ei;
            return match.getElement().equals(fi.getFile());
        }
        return false;
    }

    public Match[] findContainedMatches(IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            FileEditorInput fi = (FileEditorInput)ei;
            return this.getMatches(fi.getFile());
        }
        return this.EMPTY_ARR;
    }

    public String getLabel() {
        if (this.getMatchCount() == 1) {
            return this.fQuery.getSingularLabel();
        }
        return MessageFormat.format(this.fQuery.getPluralPattern(), new Integer(this.getMatchCount()));
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            return this.getMatches(((IFileEditorInput)ei).getFile());
        }
        return this.EMPTY_ARR;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatches(file);
    }
}

