/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.templates.ITemplate;
import org.eclipse.edt.ide.ui.templates.TemplateManager;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizardNode;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public abstract class EGLTemplateWizardPage
extends EGLPartWizardPage
implements ISelectionChangedListener,
IDoubleClickListener {
    protected TableViewer templateViewer;
    protected ScrolledFormText descriptionText;

    public EGLTemplateWizardPage(String pageName) {
        super(pageName);
    }

    protected abstract String getTemplateID();

    public String getSelectedCodeTemplateId() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            ITemplate template = (ITemplate)o;
            return template.getCodeTemplateId();
        }
        return null;
    }

    protected void createTemplateArea(Composite container, int nColumns) {
        int borderStyle;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, IUIHelpConstants.EGL_NEW_RECORD_TEMPLATE_SELECTION_PAGE);
        Composite ownerInfo = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = nColumns;
        gridLayout.marginWidth = 0;
        ownerInfo.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = nColumns;
        ownerInfo.setLayoutData((Object)gridData);
        int templateCol = nColumns % 2;
        int descriptionCol = nColumns - templateCol;
        Label label = new Label(ownerInfo, 0);
        label.setText(NewWizardMessages.TemplateSelectionPage_selectTemplate);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        label.setLayoutData((Object)gd);
        this.templateViewer = new TableViewer(ownerInfo, 2048);
        Table control = this.templateViewer.getTable();
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 200;
        data.horizontalSpan = templateCol;
        control.setLayoutData((Object)data);
        String templateID = this.getTemplateID();
        ITemplate[] templates = TemplateManager.getInstance().getTemplates(templateID);
        this.templateViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.templateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.templateViewer.setInput((Object)templates);
        this.templateViewer.addDoubleClickListener((IDoubleClickListener)this);
        FormToolkit toolkit = new FormToolkit(container.getDisplay());
        this.descriptionText = new ScrolledFormText(ownerInfo, 768, false);
        int n = borderStyle = toolkit.getBorderStyle() == 2048 ? 0 : 2048;
        if (borderStyle == 0) {
            this.descriptionText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            toolkit.paintBordersFor(ownerInfo);
        }
        FormText ftext = toolkit.createFormText((Composite)this.descriptionText, false);
        this.descriptionText.setFormText(ftext);
        this.descriptionText.setExpandHorizontal(false);
        this.descriptionText.setExpandVertical(false);
        this.descriptionText.setBackground(toolkit.getColors().getBackground());
        this.descriptionText.setForeground(toolkit.getColors().getForeground());
        ftext.marginWidth = 2;
        ftext.marginHeight = 2;
        data = new GridData(1808);
        data.widthHint = 200;
        data.horizontalSpan = descriptionCol;
        this.descriptionText.setLayoutData((Object)data);
        if (templates != null) {
            int i = 0;
            while (i < templates.length) {
                if (templates[i].isDefault()) {
                    this.templateViewer.setSelection((ISelection)new StructuredSelection(new Object[]{templates[i]}), true);
                }
                ++i;
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            this.handleSelectedTemplate();
            this.setTemplateDescription(((ITemplate)o).getDescription());
        }
        this.validateTemplatePage();
    }

    protected boolean isValidTemplateToCompletePage() {
        boolean res = false;
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            ITemplate template = (ITemplate)o;
            TemplateWizardNode wizNode = (TemplateWizardNode)template.getWizardNode();
            String templateID = ((ITemplate)o).getCodeTemplateId();
            res = wizNode != null && wizNode.isContentCreated() && wizNode.getWizard() != null && wizNode.getWizard().canFinish() || templateID != null;
        }
        return res;
    }

    protected void validateTemplatePage() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            ITemplate template = (ITemplate)o;
            this.handleSelectedTemplate();
            boolean b = this.isValidTemplateToCompletePage();
            b = template.hasWizard() ? b && this.isPageComplete() : b && this.validateEGLPartName();
            this.setPageComplete(b);
        } else {
            this.setPageComplete(false);
        }
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.validateEGLPartName() && this.isValidTemplateToCompletePage() && this.isValidPage();
    }

    protected void handleSelectedTemplate() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            ITemplate template = (ITemplate)o;
            TemplateWizardNode wizNode = (TemplateWizardNode)template.getWizardNode();
            if (wizNode != null) {
                wizNode.setParentWizard(this.getWizard());
                this.setSelectedNode(wizNode);
            } else {
                this.setSelectedNode(null);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validateTemplatePage();
        }
    }

    private void setTemplateDescription(String text) {
        try {
            this.descriptionText.setText(text != null ? text : "");
        }
        catch (Exception exception) {
            this.descriptionText.setText("");
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.validateEGLPartName() && this.isValidPage();
    }

    private boolean validateEGLPartName() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(this.getFileConfiguration().getFileName(), 1);
        return status.isOK();
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.templateViewer && this.validatePage(false)) {
            if (this.getSelectedNode() != null) {
                IWizard wiz = this.getWizard();
                WizardDialog d = (WizardDialog)wiz.getContainer();
                d.showPage(this.getNextPage());
            } else if (this.getWizard().canFinish() && this.getWizard().performFinish()) {
                this.getWizard().getContainer().getShell().close();
            }
        }
    }

    private class TreeContentProvider
    implements IStructuredContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object input) {
            return (ITemplate[])input;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TreeLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ITemplate && ((ITemplate)element).getIcon() != null) {
                return ((ITemplate)element).getIcon().createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ITemplate) {
                return ((ITemplate)element).getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

