/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.diff;

import java.util.List;
import org.assertj.core.util.diff.Chunk;
import org.assertj.core.util.diff.Delta;

public class DeleteDelta<T>
extends Delta<T> {
    public DeleteDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws IllegalStateException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position);
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.DELETE;
    }

    @Override
    public void verify(List<T> target) throws IllegalStateException {
        this.getOriginal().verify(target);
    }

    public String toString() {
        return String.format("Missing content at line %s:%n  %s%n", this.lineNumber(), this.formatLines(this.getOriginal().getLines()));
    }
}

