/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequence;

import jakarta.validation.GroupDefinitionException;
import jakarta.validation.GroupSequence;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequence.Complete;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequence.TestEntity;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class SequenceResolutionTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)SequenceResolutionTest.webArchiveBuilder().withTestClassPackage(SequenceResolutionTest.class)).build();
    }

    @Test(expectedExceptions={GroupDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="i"), @SpecAssertion(section="exception-groupdefinition", id="a")})
    public void testInvalidDefinitionOfDefaultSequenceInEntity() {
        Validator validator = TestUtil.getValidatorUnderTest();
        TestEntity entity = new TestEntity();
        validator.validate((Object)entity, new Class[]{Complete.class});
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="c")
    public void testGroupSequenceContainerOtherGroupSequences() {
        Validator validator = TestUtil.getValidatorUnderTest();
        TestEntity entity = new TestEntity();
        try {
            validator.validate((Object)entity, new Class[]{InvalidGroupSequence.class});
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="j")
    public void testOnlyFirstGroupInSequenceGetEvaluated() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Car car = new Car("USd-298");
        Set violations = validator.validate((Object)car, new Class[]{First.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class));
        violations = validator.validate((Object)car, new Class[]{Second.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class), ConstraintViolationAssert.violationOf(Pattern.class));
        violations = validator.validate((Object)car, new Class[]{All.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class));
        violations = validator.validate((Object)car, new Class[]{AllReverse.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class), ConstraintViolationAssert.violationOf(Pattern.class));
    }

    @GroupSequence(value={First.class, Third.class, Mixed.class})
    static interface InvalidGroupSequence {
    }

    class Car {
        @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class})
        private @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class}) String licensePlateNumber;
        @NotNull(groups={Second.class})
        private String make;

        Car(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }

        public String getLicensePlateNumber() {
            return this.licensePlateNumber;
        }
    }

    static interface First {
    }

    static interface Second {
    }

    @GroupSequence(value={First.class, Second.class, Third.class})
    static interface All {
    }

    @GroupSequence(value={Third.class, Second.class, First.class})
    static interface AllReverse {
    }

    @GroupSequence(value={Second.class, Third.class, First.class})
    static interface Mixed {
    }

    static interface Third {
    }
}

