/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.messageinterpolation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.MessageInterpolator;
import javax.validation.Payload;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class MessageInterpolationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)MessageInterpolationTest.webArchiveBuilder().withTestClass(MessageInterpolationTest.class)).withResource("ValidationMessages.properties", "ValidationMessages.properties", true)).withResource("ValidationMessages_de.properties", "ValidationMessages_de.properties", true)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="a"), @SpecAssertion(section="validationapi-message-customresolution", id="f"), @SpecAssertion(section="validationapi-bootstrapping-configuration", id="a")})
    public void testDefaultMessageInterpolatorIsNotNull() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        Assert.assertNotNull((Object)interpolator, (String)"Each bean validation provider must provide a default message interpolator.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="e"), @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-resolutionalgorithm", id="a"), @SpecAssertion(section="validationapi-message-customresolution", id="f"), @SpecAssertion(section="validationapi-bootstrapping-configuration", id="a")})
    public void testSuccessfulInterpolationOfValidationMessagesValue() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "replacement worked";
        String actual = interpolator.interpolate("{foo}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "replacement worked replacement worked";
        actual = interpolator.interpolate("{foo} {foo}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "This replacement worked just fine";
        actual = interpolator.interpolate("This {foo} just fine", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "{} replacement worked {unknown}";
        actual = interpolator.interpolate("{} {foo} {unknown}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-resolutionalgorithm", id="b")
    public void testRecursiveMessageInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "fubar");
        TestContext context = new TestContext(descriptor);
        String expected = "recursion worked";
        String actual = interpolator.interpolate(descriptor.getMessageTemplate(), (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Expansion should be recursive");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="d")
    public void testMessagesCanBeOverriddenAtConstraintLevel() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateProperty((Object)new DummyEntity(), "snafu", new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(constraintViolations, "messages can also be overridden at constraint declaration.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="f"), @SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="g"), @SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="h"), @SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="i")})
    public void testEscapedCharactersAreConsideredAsLiterals() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "{";
        String actual = interpolator.interpolate("\\{", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "}";
        actual = interpolator.interpolate("\\}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "\\";
        actual = interpolator.interpolate("\\", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "$";
        actual = interpolator.interpolate("\\$", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-resolutionalgorithm", id="a")
    public void testUnSuccessfulInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "foo";
        String actual = interpolator.interpolate("foo", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "#{foo  {}";
        actual = interpolator.interpolate("#{foo  {}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-resolutionalgorithm", id="a")
    public void testUnknownTokenInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "{bar}";
        String actual = interpolator.interpolate("{bar}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-resolutionalgorithm", id="c")
    public void testParametersAreExtractedFromBeanValidationProviderBundle() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(Person.class, "birthday");
        TestContext context = new TestContext(descriptor);
        String key = "{javax.validation.constraints.Past.message}";
        String actual = interpolator.interpolate(key, (MessageInterpolator.Context)context);
        Assert.assertFalse((boolean)key.equals(actual), (String)"There should have been a message interpolation from the bean validator provider bundle.");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-resolutionalgorithm", id="f")
    public void testConstraintAttributeValuesAreInterpolated() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "bar");
        TestContext context = new TestContext(descriptor);
        String expected = "size must be between 5 and 10";
        String actual = interpolator.interpolate(descriptor.getMessageTemplate(), (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-resolutionalgorithm", id="f")
    public void testParameterInterpolationHasPrecedenceOverExpressionEvaluation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "amount");
        TestContext context = new TestContext(descriptor);
        String expected = "must be $5 at least";
        String actual = interpolator.interpolate(descriptor.getMessageTemplate(), (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-resolutionalgorithm", id="g")
    public void testElExpressionsAreInterpolated() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "doubleAmount");
        TestContext context = new TestContext(descriptor);
        String expected = "must be 10 at least";
        String actual = interpolator.interpolate(descriptor.getMessageTemplate(), (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-locale", id="a")
    public void testMessageInterpolationWithLocale() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "kann nicht null sein";
        String actual = interpolator.interpolate(descriptor.getMessageTemplate(), (MessageInterpolator.Context)context, Locale.GERMAN);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="validationapi-message-defaultmessageinterpolation-locale", id="b")
    public void testIfNoLocaleIsSpecifiedTheDefaultLocaleIsAssumed() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        String messageTemplate = descriptor.getMessageTemplate();
        TestContext context = new TestContext(descriptor);
        String messageInterpolatedWithNoLocale = interpolator.interpolate(messageTemplate, (MessageInterpolator.Context)context);
        String messageInterpolatedWithDefaultLocale = interpolator.interpolate(messageTemplate, (MessageInterpolator.Context)context, Locale.getDefault());
        Assert.assertEquals((String)messageInterpolatedWithNoLocale, (String)messageInterpolatedWithDefaultLocale, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-message-customresolution", id="a"), @SpecAssertion(section="validationapi-message-customresolution", id="b"), @SpecAssertion(section="validationapi-message-customresolution", id="c")})
    public void testCorrectValuesArePassedToInterpolateForPropertyConstraint() {
        TestMessageInterpolator messageInterpolator = new TestMessageInterpolator();
        Validator validator = TestUtil.getConfigurationUnderTest().messageInterpolator((MessageInterpolator)messageInterpolator).buildValidatorFactory().getValidator();
        String name = "Bob";
        validator.validate((Object)new TestBeanWithPropertyConstraint(name), new Class[0]);
        Assert.assertEquals((String)messageInterpolator.messageTemplate, (String)"name must not be null");
        ConstraintDescriptor<?> constraintDescriptor = messageInterpolator.constraintDescriptor;
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), Size.class);
        Assert.assertEquals((String)constraintDescriptor.getMessageTemplate(), (String)"name must not be null");
        Assert.assertEquals((Object)messageInterpolator.validatedValue, (Object)name);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-message-customresolution", id="a"), @SpecAssertion(section="validationapi-message-customresolution", id="b"), @SpecAssertion(section="validationapi-message-customresolution", id="c")})
    public void testCorrectValuesArePassedToInterpolateForClassLevelConstraint() {
        TestMessageInterpolator messageInterpolator = new TestMessageInterpolator();
        Validator validator = TestUtil.getConfigurationUnderTest().messageInterpolator((MessageInterpolator)messageInterpolator).buildValidatorFactory().getValidator();
        TestBeanWithClassLevelConstraint testBean = new TestBeanWithClassLevelConstraint();
        validator.validate((Object)testBean, new Class[0]);
        Assert.assertEquals((String)messageInterpolator.messageTemplate, (String)"Invalid test bean");
        ConstraintDescriptor<?> constraintDescriptor = messageInterpolator.constraintDescriptor;
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), ValidTestBean.class);
        Assert.assertEquals((String)constraintDescriptor.getMessageTemplate(), (String)"Invalid test bean");
        Assert.assertEquals((Object)messageInterpolator.validatedValue, (Object)testBean);
    }

    @Test
    @SpecAssertion(section="validationapi-message-customresolution", id="g")
    public void testExceptionDuringMessageInterpolationIsWrappedIntoValidationException() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        ExceptionThrowingMessageInterpolator interpolator = new ExceptionThrowingMessageInterpolator();
        Validator validator = factory.usingContext().messageInterpolator((MessageInterpolator)interpolator).getValidator();
        try {
            validator.validate((Object)new TestBeanWithPropertyConstraint("Bob"), new Class[0]);
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (ValidationException ve) {
            Assert.assertEquals((Object)ve.getCause(), (Object)interpolator.exception);
        }
    }

    private ConstraintDescriptor<?> getDescriptorFor(Class<?> clazz, String propertyName) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return (ConstraintDescriptor)validator.getConstraintsForClass(clazz).getConstraintsForProperty(propertyName).getConstraintDescriptors().iterator().next();
    }

    private static class MyInterpolationException
    extends RuntimeException {
        private MyInterpolationException() {
        }
    }

    private static class ExceptionThrowingMessageInterpolator
    implements MessageInterpolator {
        private final RuntimeException exception = new MyInterpolationException();

        private ExceptionThrowingMessageInterpolator() {
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
            throw this.exception;
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
            throw new UnsupportedOperationException("No specific locale is possible");
        }
    }

    @Documented
    @Constraint(validatedBy={Validator.class})
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidTestBean {
        public String message() default "default message";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<ValidTestBean, TestBeanWithClassLevelConstraint> {
            public boolean isValid(TestBeanWithClassLevelConstraint object, ConstraintValidatorContext constraintValidatorContext) {
                return false;
            }
        }
    }

    private static class TestMessageInterpolator
    implements MessageInterpolator {
        public String messageTemplate;
        public ConstraintDescriptor<?> constraintDescriptor;
        public Object validatedValue;

        private TestMessageInterpolator() {
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
            this.messageTemplate = messageTemplate;
            this.constraintDescriptor = context.getConstraintDescriptor();
            this.validatedValue = context.getValidatedValue();
            return null;
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
            throw new UnsupportedOperationException("No specific locale is possible");
        }
    }

    @ValidTestBean(message="Invalid test bean")
    private static class TestBeanWithClassLevelConstraint {
        public static final String MESSAGE = "Invalid test bean";

        private TestBeanWithClassLevelConstraint() {
        }
    }

    private static class TestBeanWithPropertyConstraint {
        private static final String MESSAGE = "name must not be null";
        @Size(message="name must not be null", min=5)
        private final @Size(message="name must not be null", min=5) String name;

        public TestBeanWithPropertyConstraint(String name) {
            this.name = name;
        }
    }

    public class Person {
        String name;
        @Past
        Date birthday;
    }

    public class DummyEntity {
        @NotNull
        String foo;
        @Size(min=5, max=10, message="size must be between {min} and {max}")
        @Size(min=5, max=10, message="size must be between {min} and {max}") String bar;
        @Max(value=10L, message="{replace.in.user.bundle1}")
        @Max(value=10L, message="{replace.in.user.bundle1}") String fubar;
        @NotNull(message="messages can also be overridden at constraint declaration.")
        @NotNull(message="messages can also be overridden at constraint declaration.") String snafu;
        @Min(value=5L, message="must be ${value} at least")
        @Min(value=5L, message="must be ${value} at least") Integer amount = 3;
        @Min(value=5L, message="must be ${value * 2} at least")
        @Min(value=5L, message="must be ${value * 2} at least") Integer doubleAmount = 3;
    }

    public class TestContext
    implements MessageInterpolator.Context {
        ConstraintDescriptor<?> descriptor;

        TestContext(ConstraintDescriptor<?> descriptor) {
            this.descriptor = descriptor;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.descriptor;
        }

        public Object getValidatedValue() {
            return null;
        }

        public <T> T unwrap(Class<T> type) {
            throw new RuntimeException("ups");
        }
    }
}

