/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.ExecutableDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.MethodType;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.Account;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerService;
import org.hibernate.beanvalidation.tck.tests.metadata.Executables;
import org.hibernate.beanvalidation.tck.tests.metadata.Man;
import org.hibernate.beanvalidation.tck.tests.metadata.Order;
import org.hibernate.beanvalidation.tck.tests.metadata.UnconstrainedEntity;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class BeanDescriptorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)BeanDescriptorTest.webArchiveBuilder().withTestClassPackage(BeanDescriptorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassReturnsBeanClass() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Customer.class);
        Assert.assertEquals((Object)beanDescriptor.getElementClass(), Customer.class, (String)"Wrong element class");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="a")})
    public void testIsBeanConstrainedDueToValidAnnotation() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Customer.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @valid ");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="a")})
    public void testIsBeanConstrainedDueToConstraintOnEntity() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Account.class);
        Assert.assertTrue((boolean)beanDescriptor.hasConstraints(), (String)"There should be direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @valid");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="a")})
    public void testIsBeanConstrainedDueToConstraintProperty() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Order.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @NotNull");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="a")})
    public void testIsBeanConstrainedDueToConstraintOnInterface() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Man.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to constraints on Person.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="a")})
    public void testUnconstrainedClass() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(UnconstrainedEntity.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be unconstrained.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="b")})
    public void testGetConstraintsForConstrainedProperty() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Order.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderNumber");
        Assert.assertEquals((int)propertyDescriptor.getConstraintDescriptors().size(), (int)1, (String)"There should be one constraint descriptor");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-beandescriptor", id="b"), @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")})
    public void testGetConstraintsForUnConstrainedProperty() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Customer.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderList");
        Assert.assertEquals((int)propertyDescriptor.getConstraintDescriptors().size(), (int)0, (String)"There should be no constraint descriptors");
        Assert.assertTrue((boolean)propertyDescriptor.isCascaded(), (String)"The property should be cascaded");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="b")})
    public void testGetConstraintsForNonExistingProperty() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Order.class);
        Assert.assertNull((Object)beanDescriptor.getConstraintsForProperty("foobar"), (String)"There should be no descriptor");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="d")})
    public void testGetConstrainedProperties() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Order.class);
        Set constraintProperties = beanDescriptor.getConstrainedProperties();
        Assert.assertEquals((int)constraintProperties.size(), (int)1, (String)"There should be only one property");
        boolean hasOrderNumber = false;
        for (PropertyDescriptor pd : constraintProperties) {
            hasOrderNumber |= pd.getPropertyName().equals("orderNumber");
        }
        Assert.assertTrue((boolean)hasOrderNumber, (String)"Wrong property");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-validator", id="a"), @SpecAssertion(section="constraintmetadata-beandescriptor", id="d")})
    public void testGetConstrainedPropertiesForUnconstrainedEntity() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(UnconstrainedEntity.class);
        Set constraintProperties = beanDescriptor.getConstrainedProperties();
        Assert.assertEquals((int)constraintProperties.size(), (int)0, (String)"We should get the empty set.");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="c")
    public void testGetConstraintsForNullProperty() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(Order.class);
        beanDescriptor.getConstraintsForProperty(null);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="e")
    public void testGetConstraintsForParameterConstrainedMethod() {
        MethodDescriptor methodDescriptor = Executables.parameterConstrainedMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="e")
    public void testGetConstraintsForCrossParameterConstrainedMethod() {
        MethodDescriptor methodDescriptor = Executables.crossParameterConstrainedMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="e")
    public void testGetConstraintsForCascadedParameterMethod() {
        MethodDescriptor methodDescriptor = Executables.cascadedParameterMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="e")
    public void testGetConstraintsForReturnValueConstrainedMethod() {
        MethodDescriptor methodDescriptor = Executables.returnValueConstrainedMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="e")
    public void testGetConstraintsForCascadedReturnValueMethod() {
        MethodDescriptor methodDescriptor = Executables.cascadedReturnValueMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="e")
    public void testGetConstraintsForUnconstrainedMethod() {
        MethodDescriptor methodDescriptor = Executables.unconstrainedMethod();
        Assert.assertNull((Object)methodDescriptor, (String)"Descriptor should be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="e")
    public void testGetConstraintsForNonExistingMethod() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(CustomerService.class);
        MethodDescriptor methodDescriptor = beanDescriptor.getConstraintsForMethod("foo", new Class[0]);
        Assert.assertNull((Object)methodDescriptor, (String)"Descriptor should be null");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="e")
    public void testGetConstraintsForNullMethod() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(CustomerService.class);
        beanDescriptor.getConstraintsForMethod(null, new Class[0]);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="f")
    public void testGetConstrainedMethodsTypeNON_GETTER() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(CustomerService.class);
        Set methodDescriptors = beanDescriptor.getConstrainedMethods(MethodType.NON_GETTER, new MethodType[0]);
        Assertions.assertThat((Iterable)methodDescriptors).extracting(ExecutableDescriptor::getName).containsExactlyInAnyOrder((Object[])new String[]{"createCustomer", "reset", "removeCustomer", "findCustomer", "findCustomer", "updateAccount", "updateAccountStrictly", "updateCustomer", "createOrder", "getOrderContent"});
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="f")
    public void testGetConstrainedMethodsTypeGETTER() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(CustomerService.class);
        Set methodDescriptors = beanDescriptor.getConstrainedMethods(MethodType.GETTER, new MethodType[0]);
        Assert.assertEquals((int)methodDescriptors.size(), (int)1);
        Assert.assertEquals((String)((MethodDescriptor)methodDescriptors.iterator().next()).getName(), (String)"getBestCustomer");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="f")
    public void testGetConstrainedMethodsTypesGETTERAndNON_GETTER() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(CustomerService.class);
        Set methodDescriptors = beanDescriptor.getConstrainedMethods(MethodType.GETTER, new MethodType[]{MethodType.NON_GETTER});
        Assertions.assertThat((Iterable)methodDescriptors).extracting(ExecutableDescriptor::getName).containsExactlyInAnyOrder((Object[])new String[]{"createCustomer", "reset", "removeCustomer", "findCustomer", "findCustomer", "updateAccount", "updateAccountStrictly", "updateCustomer", "createOrder", "getOrderContent", "getBestCustomer"});
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="f")
    public void testGetConstrainedMethodsForUnconstrainedEntity() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(UnconstrainedEntity.class);
        Set methodDescriptors = beanDescriptor.getConstrainedMethods(MethodType.GETTER, new MethodType[]{MethodType.NON_GETTER});
        Assert.assertEquals((int)methodDescriptors.size(), (int)0, (String)"We should get the empty set.");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="g")
    public void testGetConstraintsForParameterConstrainedConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.parameterConstrainedConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="g")
    public void testGetConstraintsForCrossParameterConstrainedConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.crossParameterConstrainedConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="g")
    public void testGetConstraintsForCascadedParameterConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.cascadedParameterConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="g")
    public void testGetConstraintsForReturnValueConstrainedConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="g")
    public void testGetConstraintsForCascadedReturnValueConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.cascadedReturnValueConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="g")
    public void testGetConstraintsForUnconstrainedConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.unconstrainedConstructor();
        Assert.assertNull((Object)constructorDescriptor, (String)"Descriptor should be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="g")
    public void testGetConstraintsForNonExistingConstructorConstructor() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(CustomerService.class);
        ConstructorDescriptor constructorDescriptor = beanDescriptor.getConstraintsForConstructor(new Class[]{Short.class});
        Assert.assertNull((Object)constructorDescriptor, (String)"Descriptor should be null");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="h")
    public void testGetConstrainedConstructors() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(CustomerService.class);
        Set constructorDescriptors = beanDescriptor.getConstrainedConstructors();
        Set<List<Class<?>>> actualParameterTypes = this.getParameterTypes(constructorDescriptors);
        ((IterableAssert)Assertions.assertThat(actualParameterTypes).describedAs("Wrong constructors", new Object[0])).containsExactlyInAnyOrder((Object[])new List[]{Collections.emptyList(), Arrays.asList(String.class, String.class), Arrays.asList(Customer.class), Arrays.asList(Account.class), Arrays.asList(Integer.TYPE, Account.class), Arrays.asList(Long.TYPE), Arrays.asList(Long.TYPE, Integer.TYPE), Arrays.asList(Map.class)});
    }

    @Test
    @SpecAssertion(section="constraintmetadata-beandescriptor", id="h")
    public void testGetConstrainedConstructorsForUnconstrainedEntity() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(UnconstrainedEntity.class);
        Set constructorDescriptors = beanDescriptor.getConstrainedConstructors();
        Assert.assertEquals((int)constructorDescriptors.size(), (int)0, (String)"We should get the empty set.");
    }

    private Set<List<Class<?>>> getParameterTypes(Set<ConstructorDescriptor> constructorDescriptors) {
        HashSet parameterTypes = new HashSet();
        for (ConstructorDescriptor constructorDescriptor : constructorDescriptors) {
            ArrayList<Class> types = new ArrayList<Class>();
            for (ParameterDescriptor parameterDescriptor : constructorDescriptor.getParameterDescriptors()) {
                types.add(parameterDescriptor.getElementClass());
            }
            parameterTypes.add(types);
        }
        return parameterTypes;
    }
}

