/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.LogFacade;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarUtil {
    public static final String JAXR_RA_NAME = "jaxr-ra";
    public static final String JDBCDATASOURCE_RA_NAME = "__ds_jdbc_ra";
    public static final String JDBCCONNECTIONPOOLDATASOURCE_RA_NAME = "__cp_jdbc_ra";
    public static final String JDBCXA_RA_NAME = "__xa_jdbc_ra";
    public static final String JDBCDRIVER_RA_NAME = "__dm_jdbc_ra";
    public static final String DEFAULT_JMS_ADAPTER = "jmsra";
    public static final String RAR_EXTENSION = ".rar";
    public static final List<String> systemRarNames = Collections.unmodifiableList(Arrays.asList("jaxr-ra", "__ds_jdbc_ra", "__cp_jdbc_ra", "__xa_jdbc_ra", "__dm_jdbc_ra", "jmsra"));
    private static final Logger logger = LogFacade.BOOTSTRAP_LOGGER;

    public static boolean extractRars(String installDir) {
        boolean extracted = true;
        for (String rarName : systemRarNames) {
            extracted &= JarUtil.extractRar(installDir, rarName);
        }
        return extracted;
    }

    public static void setEnv(String installDir) {
        String location = JarUtil.getSystemModuleLocation(installDir, DEFAULT_JMS_ADAPTER);
        String imqLib = System.getProperty("com.sun.aas.imqLib", location);
        System.setProperty("com.sun.aas.imqLib", imqLib);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean extractRar(String installDir, String rarName) {
        if (JarUtil.systemModuleLocationExists(installDir, rarName)) {
            return false;
        }
        String rarFileName = rarName + RAR_EXTENSION;
        try (InputStream rarInJar = JarUtil.class.getClassLoader().getResourceAsStream(rarFileName);){
            boolean bl;
            if (rarInJar == null) {
                logger.log(Level.CONFIG, "The RAR file wasn't found: [" + rarFileName + "]");
                boolean bl2 = false;
                return bl2;
            }
            JarInputStream jarInputStream = new JarInputStream(rarInJar);
            try {
                JarUtil.extractJar(jarInputStream, installDir);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception while extracting resource [" + rarFileName + "]", e);
                    boolean bl3 = false;
                    return bl3;
                }
            }
            jarInputStream.close();
            return bl;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected exception when opening resource [" + rarFileName + "]", e);
        }
    }

    private static boolean systemModuleLocationExists(String installDir, String rarName) {
        return new File(JarUtil.getSystemModuleLocation(installDir, rarName)).exists();
    }

    private static String getSystemModuleLocation(String installDir, String rarName) {
        return installDir + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + rarName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJar(JarInputStream jar, String destDir) throws IOException {
        JarEntry entry;
        block10: while ((entry = jar.getNextJarEntry()) != null) {
            try {
                File outputFile = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    outputFile.mkdirs();
                    continue;
                }
                if (outputFile.exists()) continue;
                FileOutputStream out = new FileOutputStream(outputFile);
                try {
                    byte[] buffer = new byte[1024];
                    int readCount = 0;
                    while (true) {
                        if ((readCount = jar.read(buffer)) < 0) continue block10;
                        out.write(buffer, 0, readCount);
                    }
                }
                finally {
                    out.close();
                    continue;
                }
            }
            finally {
                jar.closeEntry();
                continue;
            }
            break;
        }
        return;
    }
}

