/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.VersionUpgrade;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.xml.DTDRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

@Service
@PerLookup
public class SaxParserHandler
extends DefaultHandler {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final MappingStuff _mappingStuff = new MappingStuff();
    private final List<XMLNode> nodes = new ArrayList<XMLNode>();
    public XMLNode topNode = null;
    protected String publicID = null;
    private StringBuffer elementData = null;
    private Map<String, String> prefixMapping = null;
    private boolean stopOnXMLErrors = false;
    private boolean pushedNamespaceContext = false;
    private NamespaceSupport namespaces = new NamespaceSupport();
    private Stack elementStack = new Stack();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SaxParserHandler.class);
    private String rootElement = null;
    private List<VersionUpgrade> versionUpgradeList = null;
    private boolean doDelete = false;
    private String errorReportingString = "";

    protected static Map<String, String> getMapping() {
        return SaxParserHandler._mappingStuff.mMapping;
    }

    protected static List<VersionUpgrade> getVersionUpgrades(String key) {
        List<VersionUpgrade> versionUpgradeList = SaxParserHandler._mappingStuff.mVersionUpgrades.get(key);
        if (versionUpgradeList != null) {
            return versionUpgradeList;
        }
        List<Class> classList = SaxParserHandler._mappingStuff.mVersionUpgradeClasses.get(key);
        if (classList == null) {
            return null;
        }
        versionUpgradeList = new ArrayList<VersionUpgrade>();
        for (int n = 0; n < classList.size(); ++n) {
            VersionUpgrade versionUpgrade = null;
            try {
                versionUpgrade = (VersionUpgrade)classList.get(n).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (versionUpgrade == null) continue;
            versionUpgradeList.add(versionUpgrade);
        }
        SaxParserHandler._mappingStuff.mVersionUpgrades.put(key, versionUpgradeList);
        return versionUpgradeList;
    }

    protected static Collection<String> getElementsAllowingEmptyValues() {
        return SaxParserHandler._mappingStuff.mElementsAllowingEmptyValues;
    }

    protected static Collection<String> getElementsPreservingWhiteSpace() {
        return SaxParserHandler._mappingStuff.mElementsPreservingWhiteSpace;
    }

    public static void registerBundleNode(BundleNode bn, String bundleTagName) {
        if (SaxParserHandler._mappingStuff.mBundleRegistrationStatus.containsKey(bundleTagName)) {
            return;
        }
        HashMap<String, String> dtdMapping = new HashMap<String, String>();
        HashMap<String, List<Class>> versionUpgrades = new HashMap<String, List<Class>>();
        String rootNodeKey = bn.registerBundle(dtdMapping);
        SaxParserHandler._mappingStuff.mRootNodesMutable.putIfAbsent(rootNodeKey, bn.getClass());
        SaxParserHandler._mappingStuff.mRootNodesMutable.putAll(bn.registerRuntimeBundle(dtdMapping, versionUpgrades));
        SaxParserHandler._mappingStuff.mVersionUpgradeClasses.putAll(versionUpgrades);
        for (Map.Entry<String, String> entry : dtdMapping.entrySet()) {
            String dtd;
            String publicID = entry.getKey();
            String systemIDResolution = SaxParserHandler.resolvePublicID(publicID, dtd = entry.getValue());
            if (systemIDResolution == null) {
                SaxParserHandler._mappingStuff.mMapping.put(publicID, dtd.substring(dtd.lastIndexOf(47) + 1));
                continue;
            }
            SaxParserHandler._mappingStuff.mMapping.put(publicID, systemIDResolution);
        }
        Collection<String> c = bn.elementsAllowingEmptyValue();
        if (c.size() > 0) {
            SaxParserHandler._mappingStuff.mElementsAllowingEmptyValuesMutable.addAll(c);
        }
        if ((c = bn.elementsPreservingWhiteSpace()).size() > 0) {
            SaxParserHandler._mappingStuff.mElementsPreservingWhiteSpaceMutable.addAll(c);
        }
        SaxParserHandler._mappingStuff.mBundleRegistrationStatus.put(rootNodeKey, Boolean.TRUE);
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        try {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Asked to resolve  " + publicID + " system id = " + systemID);
            }
            if (publicID != null && SaxParserHandler.getMapping().containsKey(publicID)) {
                this.publicID = publicID;
                return new InputSource(new BufferedInputStream(this.getDTDUrlFor(SaxParserHandler.getMapping().get(publicID))));
            }
            if (systemID == null || systemID.lastIndexOf(47) == systemID.length()) {
                return null;
            }
            String fileName = null;
            String namespaceResolution = SaxParserHandler.resolveSchemaNamespace(systemID);
            fileName = namespaceResolution != null ? SaxParserHandler.getSchemaURLFor(namespaceResolution) : SaxParserHandler.getSchemaURLFor(systemID.substring(systemID.lastIndexOf(47) + 1));
            if (fileName == null) {
                throw new SAXException(localStrings.getLocalString("invalid.schema", "Requested schema is not found in local repository, please ensure that there are no typos in the XML namespace declaration."));
            }
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Resolved to " + fileName);
            }
            return new InputSource(fileName);
        }
        catch (SAXException e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception ioe) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, ioe.getMessage(), ioe);
            throw new SAXException(ioe);
        }
    }

    public void setStopOnError(boolean stop) {
        this.stopOnXMLErrors = stop;
    }

    @Override
    public void error(SAXParseException spe) throws SAXParseException {
        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorFailure", new Object[]{this.errorReportingString, String.valueOf(spe.getLineNumber()), String.valueOf(spe.getColumnNumber()), spe.getLocalizedMessage()});
        if (this.stopOnXMLErrors) {
            throw spe;
        }
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXParseException {
        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorFailure", new Object[]{this.errorReportingString, String.valueOf(spe.getLineNumber()), String.valueOf(spe.getColumnNumber()), spe.getLocalizedMessage()});
        if (this.stopOnXMLErrors) {
            throw spe;
        }
    }

    protected InputStream getDTDUrlFor(String dtdFileName) {
        String dtdLoc = DTDRegistry.DTD_LOCATION.replace('/', File.separatorChar);
        File f = new File(dtdLoc + File.separatorChar + dtdFileName);
        try {
            return new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException fnfe) {
            DOLUtils.getDefaultLogger().fine("Cannot find DTD " + dtdFileName);
            return null;
        }
    }

    public static String getSchemaURLFor(String schemaSystemID) throws IOException {
        File f = SaxParserHandler.getSchemaFileFor(schemaSystemID);
        if (f != null) {
            return f.toURI().toURL().toString();
        }
        return null;
    }

    public static File getSchemaFileFor(String schemaSystemID) throws IOException {
        String schemaLoc;
        File f;
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Getting Schema " + schemaSystemID);
        }
        if (!(f = new File((schemaLoc = DTDRegistry.SCHEMA_LOCATION.replace('/', File.separatorChar)) + File.separatorChar + schemaSystemID)).exists()) {
            DOLUtils.getDefaultLogger().fine("Cannot find schema " + schemaSystemID);
            return null;
        }
        return f;
    }

    public static String resolveSchemaNamespace(String systemID) {
        List<String> namespaces = DOLUtils.getProprietarySchemaNamespaces();
        for (int n = 0; n < namespaces.size(); ++n) {
            String namespace = namespaces.get(n);
            if (!systemID.startsWith(namespace)) continue;
            return systemID.substring(namespace.length());
        }
        return null;
    }

    public static String resolvePublicID(String publicID, String dtd) {
        List<String> dtdStarts = DOLUtils.getProprietaryDTDStart();
        for (int n = 0; n < dtdStarts.size(); ++n) {
            String dtdStart = dtdStarts.get(n);
            if (!dtd.startsWith(dtdStart)) continue;
            return dtd.substring(dtdStart.length());
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Received notation " + name + " :=: " + publicId + " :=: " + systemId);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.prefixMapping == null) {
            this.prefixMapping = new HashMap<String, String>();
        }
        if (!this.pushedNamespaceContext) {
            this.namespaces.pushContext();
            this.pushedNamespaceContext = true;
        }
        this.namespaces.declarePrefix(prefix, uri);
        this.prefixMapping.put(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        VersionUpgrade versionUpgrade;
        if (!this.pushedNamespaceContext) {
            this.namespaces.pushContext();
        }
        this.pushedNamespaceContext = false;
        this.doDelete = false;
        Object lastElement = null;
        try {
            lastElement = (String)this.elementStack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (lastElement == null) {
            this.rootElement = localName;
            this.versionUpgradeList = SaxParserHandler.getVersionUpgrades(this.rootElement);
            if (this.versionUpgradeList != null) {
                for (int n = 0; n < this.versionUpgradeList.size(); ++n) {
                    versionUpgrade = this.versionUpgradeList.get(n);
                    versionUpgrade.init();
                }
            }
            this.elementStack.push(localName);
        } else {
            lastElement = (String)lastElement + "/" + localName;
            this.elementStack.push(lastElement);
        }
        if (this.versionUpgradeList != null) {
            for (int n = 0; n < this.versionUpgradeList.size(); ++n) {
                versionUpgrade = this.versionUpgradeList.get(n);
                if (VersionUpgrade.UpgradeType.REMOVE_ELEMENT != versionUpgrade.getUpgradeType()) continue;
                Map<String, String> matchXPath = versionUpgrade.getMatchXPath();
                int entriesMatched = 0;
                for (Map.Entry<String, String> entry : matchXPath.entrySet()) {
                    if (!entry.getKey().equals(lastElement)) continue;
                    entry.setValue(this.elementData.toString());
                    ++entriesMatched;
                }
                if (entriesMatched != matchXPath.size()) continue;
                this.doDelete = true;
                break;
            }
        }
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
            DOLUtils.getDefaultLogger().finer("start of element " + uri + " with local name " + localName + " and " + qName);
        }
        XMLNode node = null;
        this.elementData = new StringBuffer();
        if (this.nodes.isEmpty()) {
            Class rootNodeClass = SaxParserHandler._mappingStuff.mRootNodes.get(localName);
            if (rootNodeClass == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "AS-DEPLOYMENT-00015", new Object[]{localName, " not supported !"});
                if (this.stopOnXMLErrors) {
                    throw new IllegalArgumentException(localStrings.getLocalString("invalid.root.element", "{0} Element [{1}] is not a valid root element", new Object[]{this.errorReportingString, localName}));
                }
            } else {
                try {
                    node = (XMLNode)rootNodeClass.newInstance();
                    if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                        DOLUtils.getDefaultLogger().fine("Instanciating " + node);
                    }
                    if (node instanceof RootXMLNode) {
                        if (this.publicID != null) {
                            ((RootXMLNode)node).setDocType(this.publicID);
                        }
                        this.addPrefixMapping(node);
                    }
                    this.nodes.add(node);
                    this.topNode = node;
                    node.getDescriptor();
                }
                catch (Exception e) {
                    DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", e);
                    return;
                }
            }
        } else {
            node = this.nodes.get(this.nodes.size() - 1);
        }
        if (node != null) {
            XMLElement element = new XMLElement(qName, this.namespaces);
            if (node.handlesElement(element)) {
                node.startElement(element, attributes);
            } else {
                if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                    DOLUtils.getDefaultLogger().fine("Asking for new handler for " + element + " to " + node);
                }
                XMLNode newNode = node.getHandlerFor(element);
                if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                    DOLUtils.getDefaultLogger().fine("Got " + newNode);
                }
                this.nodes.add(newNode);
                this.addPrefixMapping(newNode);
                newNode.startElement(element, attributes);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String lastElement = null;
        try {
            lastElement = (String)this.elementStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
            DOLUtils.getDefaultLogger().finer("End of element " + uri + " local name " + localName + " and " + qName + " value " + this.elementData);
        }
        if (this.nodes.size() == 0) {
            this.elementData = null;
            return;
        }
        XMLElement element = new XMLElement(qName, this.namespaces);
        XMLNode topNode = this.nodes.get(this.nodes.size() - 1);
        if (this.elementData != null && (this.elementData.length() != 0 || this.allowsEmptyValue(element.getQName()))) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
                DOLUtils.getDefaultLogger().finer("For element " + element.getQName() + " And value " + this.elementData);
            }
            boolean doReplace = false;
            String replacementName = null;
            String replacementValue = null;
            if (this.versionUpgradeList != null) {
                for (int n = 0; n < this.versionUpgradeList.size(); ++n) {
                    VersionUpgrade versionUpgrade = this.versionUpgradeList.get(n);
                    if (VersionUpgrade.UpgradeType.REPLACE_ELEMENT != versionUpgrade.getUpgradeType()) continue;
                    Map<String, String> matchXPath = versionUpgrade.getMatchXPath();
                    int entriesMatched = 0;
                    for (Map.Entry<String, String> entry : matchXPath.entrySet()) {
                        if (!entry.getKey().equals(lastElement)) continue;
                        entry.setValue(this.elementData.toString());
                        ++entriesMatched;
                    }
                    if (entriesMatched != matchXPath.size()) continue;
                    if (versionUpgrade.isValid()) {
                        doReplace = true;
                        replacementName = versionUpgrade.getReplacementElementName();
                        replacementValue = versionUpgrade.getReplacementElementValue();
                        break;
                    }
                    StringBuffer buf = new StringBuffer();
                    String errorString = "Invalid upgrade from <";
                    buf.append(errorString);
                    for (Map.Entry<String, String> entry : matchXPath.entrySet()) {
                        buf.append(entry.getKey() + "  " + entry.getValue() + " >");
                    }
                    errorString = buf.toString();
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, errorString);
                    break;
                }
            }
            if (doReplace) {
                element = new XMLElement(replacementName, this.namespaces);
                topNode.setElementValue(element, replacementValue);
            } else if (!this.doDelete) {
                if (SaxParserHandler.getElementsPreservingWhiteSpace().contains(element.getQName())) {
                    topNode.setElementValue(element, this.elementData.toString());
                } else if (element.getQName().equals("env-entry-value")) {
                    Object envEntryDesc = topNode.getDescriptor();
                    if (envEntryDesc != null && envEntryDesc instanceof EnvironmentProperty) {
                        EnvironmentProperty envProp = (EnvironmentProperty)envEntryDesc;
                        if (envProp.getType() != null && (envProp.getType().equals("java.lang.String") || envProp.getType().equals("java.lang.Character"))) {
                            topNode.setElementValue(element, this.elementData.toString());
                        } else {
                            topNode.setElementValue(element, this.elementData.toString().trim());
                        }
                    } else {
                        topNode.setElementValue(element, this.elementData.toString().trim());
                    }
                } else {
                    String val = this.elementData.toString().trim();
                    if (TRUE_STR.equalsIgnoreCase(val)) {
                        topNode.setElementValue(element, val.toLowerCase(Locale.US));
                    } else if (FALSE_STR.equalsIgnoreCase(val)) {
                        topNode.setElementValue(element, val.toLowerCase(Locale.US));
                    } else {
                        topNode.setElementValue(element, val);
                    }
                }
            }
            this.elementData = null;
        }
        if (topNode.endElement(element)) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Removing top node " + topNode);
            }
            this.nodes.remove(this.nodes.size() - 1);
        }
        this.namespaces.popContext();
        this.pushedNamespaceContext = false;
        try {
            lastElement = (String)this.elementStack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (lastElement != null && lastElement.lastIndexOf("/") >= 0) {
            lastElement = lastElement.substring(0, lastElement.lastIndexOf("/"));
            this.elementStack.push(lastElement);
        }
    }

    @Override
    public void characters(char[] ch, int start, int stop) {
        if (this.elementData != null) {
            this.elementData = this.elementData.append(ch, start, stop);
        }
    }

    public XMLNode getTopNode() {
        return this.topNode;
    }

    public void setTopNode(XMLNode node) {
        this.topNode = node;
        this.nodes.add(node);
    }

    private void addPrefixMapping(XMLNode node) {
        if (this.prefixMapping != null) {
            for (Map.Entry<String, String> entry : this.prefixMapping.entrySet()) {
                node.addPrefixMapping(entry.getKey(), entry.getValue());
            }
            this.prefixMapping = null;
        }
    }

    public void setErrorReportingString(String s) {
        this.errorReportingString = s;
    }

    private boolean allowsEmptyValue(String elementName) {
        return SaxParserHandler.getElementsAllowingEmptyValues().contains(elementName);
    }

    private static final class MappingStuff {
        public final ConcurrentMap<String, Boolean> mBundleRegistrationStatus = new ConcurrentHashMap<String, Boolean>();
        public final ConcurrentMap<String, String> mMapping = new ConcurrentHashMap<String, String>();
        private final ConcurrentMap<String, Class> mRootNodesMutable = new ConcurrentHashMap<String, Class>();
        public final Map<String, Class> mRootNodes = Collections.unmodifiableMap(this.mRootNodesMutable);
        private final CopyOnWriteArraySet<String> mElementsAllowingEmptyValuesMutable = new CopyOnWriteArraySet();
        public final Collection<String> mElementsAllowingEmptyValues = Collections.unmodifiableSet(this.mElementsAllowingEmptyValuesMutable);
        private final CopyOnWriteArraySet<String> mElementsPreservingWhiteSpaceMutable = new CopyOnWriteArraySet();
        public final Collection<String> mElementsPreservingWhiteSpace = Collections.unmodifiableSet(this.mElementsPreservingWhiteSpaceMutable);
        private final Map<String, List<Class>> mVersionUpgradeClasses = new ConcurrentHashMap<String, List<Class>>();
        private final Map<String, List<VersionUpgrade>> mVersionUpgrades = new ConcurrentHashMap<String, List<VersionUpgrade>>();

        MappingStuff() {
        }
    }
}

