/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.cache;

import com.sun.enterprise.admin.util.cache.AdminCache;
import com.sun.enterprise.admin.util.cache.AdminCacheMemStore;
import com.sun.enterprise.admin.util.cache.ByteArrayDataProvider;
import com.sun.enterprise.admin.util.cache.CommandModelDataProvider;
import com.sun.enterprise.admin.util.cache.DataProvider;
import com.sun.enterprise.admin.util.cache.StringDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jvnet.hk2.annotations.Service;

@Service
public class AdminCacheUtils {
    private static final AdminCacheUtils instance = new AdminCacheUtils();
    private final Map<Class, DataProvider> providers = new HashMap<Class, DataProvider>();
    private final Pattern keyPattern = Pattern.compile("([-_.a-zA-Z0-9]+/?)+");
    private static final DataProvider[] allProviders = new DataProvider[]{new StringDataProvider(), new ByteArrayDataProvider(), new CommandModelDataProvider()};

    private AdminCacheUtils() {
    }

    public DataProvider getProvider(Class clazz) {
        DataProvider result = this.providers.get(clazz);
        if (result == null) {
            for (DataProvider provider : allProviders) {
                if (!provider.accept(clazz)) continue;
                this.providers.put(clazz, provider);
                return provider;
            }
            return null;
        }
        return result;
    }

    public final boolean validateKey(String key) {
        return this.keyPattern.matcher(key).matches();
    }

    public static AdminCache getCache() {
        return AdminCacheMemStore.getInstance();
    }

    public static AdminCacheUtils getInstance() {
        return instance;
    }
}

