/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.EncryptContainerOperation;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.StandardException;

public class EncryptOrDecryptData {
    private BaseDataFileFactory dataFactory;
    private StorageFactory storageFactory;
    private static final int STORAGE_FILE_EXISTS_ACTION = 1;
    private static final int STORAGE_FILE_DELETE_ACTION = 2;
    private static final int STORAGE_FILE_RENAME_ACTION = 3;
    private int actionCode;
    private StorageFile actionStorageFile;
    private StorageFile actionDestStorageFile;

    public EncryptOrDecryptData(BaseDataFileFactory baseDataFileFactory) {
        this.dataFactory = baseDataFileFactory;
        this.storageFactory = baseDataFileFactory.getStorageFactory();
    }

    public void decryptAllContainers(RawTransaction rawTransaction) throws StandardException {
        this.encryptOrDecryptAllContainers(rawTransaction, false);
    }

    public void encryptAllContainers(RawTransaction rawTransaction) throws StandardException {
        this.encryptOrDecryptAllContainers(rawTransaction, true);
    }

    private void encryptOrDecryptAllContainers(RawTransaction rawTransaction, boolean bl) throws StandardException {
        String[] stringArray = this.dataFactory.getContainerNames();
        if (stringArray != null) {
            long l = 0L;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                long l2;
                try {
                    l2 = Long.parseLong(stringArray[i].substring(1, stringArray[i].length() - 4), 16);
                }
                catch (Throwable throwable) {
                    continue;
                }
                ContainerKey containerKey = new ContainerKey(l, l2);
                this.encryptOrDecryptContainer(rawTransaction, containerKey, bl);
            }
        }
    }

    private void encryptOrDecryptContainer(RawTransaction rawTransaction, ContainerKey containerKey, boolean bl) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2;
        LockingPolicy lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
        RawContainerHandle rawContainerHandle = (RawContainerHandle)rawTransaction.openContainer(containerKey, lockingPolicy, 4);
        EncryptContainerOperation encryptContainerOperation = new EncryptContainerOperation(rawContainerHandle);
        rawTransaction.logAndDo(encryptContainerOperation);
        this.dataFactory.flush(rawTransaction.getLastLogInstant());
        String string = this.getFilePath(containerKey, false);
        StorageFile storageFile3 = this.storageFactory.newStorageFile(string);
        rawContainerHandle.encryptOrDecryptContainer(string, bl);
        rawContainerHandle.close();
        if (!this.dataFactory.getPageCache().discard(containerKey)) {
            // empty if block
        }
        if (!this.dataFactory.getContainerCache().discard(containerKey)) {
            // empty if block
        }
        if (!this.privRename(storageFile2 = this.dataFactory.getContainerPath(containerKey, false), storageFile = this.getFile(containerKey, true))) {
            throw StandardException.newException("XSRS4.S", storageFile2, storageFile);
        }
        if (!this.privRename(storageFile3, storageFile2)) {
            throw StandardException.newException("XSRS4.S", storageFile3, storageFile2);
        }
    }

    private StorageFile getFile(ContainerKey containerKey, boolean bl) {
        return this.storageFactory.newStorageFile(this.getFilePath(containerKey, bl));
    }

    private String getFilePath(ContainerKey containerKey, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("seg");
        stringBuffer.append(containerKey.getSegmentId());
        stringBuffer.append(this.storageFactory.getSeparator());
        stringBuffer.append(bl ? (char)'o' : 'n');
        stringBuffer.append(Long.toHexString(containerKey.getContainerId()));
        stringBuffer.append(".dat");
        return stringBuffer.toString();
    }

    private boolean isOldContainerFile(String string) {
        return string.startsWith("o") && string.endsWith(".dat");
    }

    private StorageFile getFile(String string) {
        long l = 0L;
        StringBuffer stringBuffer = new StringBuffer("seg");
        stringBuffer.append(l);
        stringBuffer.append(this.storageFactory.getSeparator());
        stringBuffer.append(string);
        return this.storageFactory.newStorageFile(stringBuffer.toString());
    }

    void restoreContainer(ContainerKey containerKey) throws StandardException {
        if (!this.dataFactory.getContainerCache().discard(containerKey)) {
            // empty if block
        }
        StorageFile storageFile = this.dataFactory.getContainerPath(containerKey, false);
        StorageFile storageFile2 = this.getFile(containerKey, true);
        StorageFile storageFile3 = this.getFile(containerKey, false);
        if (this.privExists(storageFile2)) {
            if (this.privExists(storageFile) && !this.privRename(storageFile, storageFile3)) {
                throw StandardException.newException("XSRS4.S", storageFile, storageFile3);
            }
            if (!this.privRename(storageFile2, storageFile)) {
                throw StandardException.newException("XSRS4.S", storageFile2, storageFile);
            }
        }
        if (this.privExists(storageFile3) && !this.privDelete(storageFile3)) {
            throw StandardException.newException("XBM0R.D", storageFile3);
        }
    }

    public void removeOldVersionOfContainers() throws StandardException {
        String[] stringArray = this.dataFactory.getContainerNames();
        if (stringArray != null) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                StorageFile storageFile;
                if (!this.isOldContainerFile(stringArray[i]) || this.privDelete(storageFile = this.getFile(stringArray[i]))) continue;
                throw StandardException.newException("XSDFJ.S", storageFile);
            }
        }
    }

    private synchronized boolean privExists(StorageFile storageFile) {
        this.actionCode = 1;
        this.actionStorageFile = storageFile;
        Boolean bl = this.run();
        this.actionStorageFile = null;
        return bl;
    }

    private synchronized boolean privDelete(StorageFile storageFile) {
        this.actionCode = 2;
        this.actionStorageFile = storageFile;
        Boolean bl = this.run();
        this.actionStorageFile = null;
        return bl;
    }

    private synchronized boolean privRename(StorageFile storageFile, StorageFile storageFile2) {
        this.actionCode = 3;
        this.actionStorageFile = storageFile;
        this.actionDestStorageFile = storageFile2;
        Boolean bl = this.run();
        this.actionStorageFile = null;
        this.actionDestStorageFile = null;
        return bl;
    }

    public Boolean run() {
        switch (this.actionCode) {
            case 1: {
                return this.actionStorageFile.exists();
            }
            case 2: {
                return this.actionStorageFile.delete();
            }
            case 3: {
                return this.actionStorageFile.renameTo(this.actionDestStorageFile);
            }
        }
        return null;
    }
}

