/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigException;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.NodeConfigSource;
import io.helidon.config.spi.ParsableSource;
import java.util.Objects;
import java.util.Optional;

class InMemoryConfigSource {
    private InMemoryConfigSource() {
    }

    static NodeConfigSource create(String uri, ConfigContent.NodeContent content) {
        Objects.requireNonNull(uri, "uri cannot be null");
        Objects.requireNonNull(content, "content cannot be null");
        return new NodeInMemory(uri, content);
    }

    static ConfigSource create(String uri, ConfigParser.Content content) {
        Objects.requireNonNull(uri, "uri cannot be null");
        Objects.requireNonNull(content, "content cannot be null");
        return new ParsableInMemory(uri, content);
    }

    private static final class NodeInMemory
    extends InMemory
    implements NodeConfigSource {
        private final ConfigContent.NodeContent content;

        private NodeInMemory(String uid, ConfigContent.NodeContent nodeContent) {
            super(uid);
            this.content = nodeContent;
        }

        public Optional<ConfigContent.NodeContent> load() throws ConfigException {
            return Optional.of(this.content);
        }
    }

    private static final class ParsableInMemory
    extends InMemory
    implements ParsableSource {
        private final ConfigParser.Content content;

        protected ParsableInMemory(String uid, ConfigParser.Content content) {
            super(uid);
            this.content = content;
        }

        public Optional<ConfigParser.Content> load() throws ConfigException {
            return Optional.of(this.content);
        }

        public Optional<ConfigParser> parser() {
            return Optional.empty();
        }

        public Optional<String> mediaType() {
            return Optional.empty();
        }
    }

    private static class InMemory
    implements ConfigSource {
        private final String uid;

        protected InMemory(String uid) {
            this.uid = uid;
        }

        public String description() {
            return super.description() + "[" + this.uid + "]";
        }
    }
}

