/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.CodeGeneration;

public class InfoFilesUtil {
    public static void createInfoJavaFile(String fileName, String fileContent, IPackageFragment pack, IProgressMonitor monitor) throws CoreException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed(pack.getJavaProject());
        StringBuilder content = new StringBuilder();
        String fileComment = InfoFilesUtil.getFileComment(fileName, pack, lineDelimiter);
        String typeComment = InfoFilesUtil.getTypeComment(fileName, pack, lineDelimiter);
        if (fileComment != null) {
            content.append(fileComment);
            content.append(lineDelimiter);
        }
        if (typeComment != null) {
            content.append(typeComment);
            content.append(lineDelimiter);
        } else if (fileComment != null) {
            content.append("/**");
            content.append(lineDelimiter);
            content.append(" *");
            content.append(lineDelimiter);
            content.append(" */");
            content.append(lineDelimiter);
        }
        content.append(fileContent);
        ICompilationUnit compilationUnit = pack.createCompilationUnit(fileName, content.toString(), true, monitor);
        JavaModelUtil.reconcile((ICompilationUnit)compilationUnit);
        compilationUnit.becomeWorkingCopy(monitor);
        try {
            IBuffer buffer = compilationUnit.getBuffer();
            ISourceRange sourceRange = compilationUnit.getSourceRange();
            String originalContent = buffer.getText(sourceRange.getOffset(), sourceRange.getLength());
            int kind = 8;
            if (fileName.equals("module-info.java")) {
                kind = 128;
            }
            String formattedContent = CodeFormatterUtil.format((int)kind, (String)originalContent, (int)0, (String)lineDelimiter, (IJavaProject)pack.getJavaProject());
            formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent);
            buffer.replace(sourceRange.getOffset(), sourceRange.getLength(), formattedContent);
            compilationUnit.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            compilationUnit.discardWorkingCopy();
        }
    }

    public static String getFileComment(String fileName, IPackageFragment pack, String lineDelimiterUsed) throws CoreException {
        ICompilationUnit cu = pack.getCompilationUnit(fileName);
        return CodeGeneration.getFileComment(cu, lineDelimiterUsed);
    }

    public static String getTypeComment(String fileName, IPackageFragment pack, String lineDelimiterUsed) throws CoreException {
        ICompilationUnit cu = pack.getCompilationUnit(fileName);
        String typeName = fileName.substring(0, fileName.length() - ".java".length());
        return CodeGeneration.getTypeComment(cu, typeName, lineDelimiterUsed);
    }
}

