/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.statement;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InterruptStatementKind implements Enumerator
{
    BREAK(0, "break", "break"),
    CONTINUE(1, "continue", "continue"),
    RETURN(2, "return", "return"),
    EXIT(3, "exit", "exit");

    public static final int BREAK_VALUE = 0;
    public static final int CONTINUE_VALUE = 1;
    public static final int RETURN_VALUE = 2;
    public static final int EXIT_VALUE = 3;
    private static final InterruptStatementKind[] VALUES_ARRAY;
    public static final List<InterruptStatementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InterruptStatementKind[]{BREAK, CONTINUE, RETURN, EXIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InterruptStatementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterruptStatementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterruptStatementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterruptStatementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterruptStatementKind get(int value) {
        switch (value) {
            case 0: {
                return BREAK;
            }
            case 1: {
                return CONTINUE;
            }
            case 2: {
                return RETURN;
            }
            case 3: {
                return EXIT;
            }
        }
        return null;
    }

    private InterruptStatementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

