/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.EndAction;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.GLViewPanelFactory;
import fr.inria.zvtm.engine.Java2DPainter;
import fr.inria.zvtm.engine.Location;
import fr.inria.zvtm.engine.OffscreenViewPanel;
import fr.inria.zvtm.engine.PanelFactory;
import fr.inria.zvtm.engine.StdViewPanelFactory;
import fr.inria.zvtm.engine.VCursor;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.engine.portals.Portal;
import fr.inria.zvtm.event.RepaintListener;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.lens.Lens;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.Timer;

public abstract class View {
    protected final Timer activeRepaintTimer = new Timer(300, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            View.this.repaint();
        }
    });
    public static final String ANONYMOUS = "AnonView";
    public static final String STD_VIEW = "std";
    public static final String OPENGL_VIEW = "ogl";
    static Hashtable<String, PanelFactory> VIEW_TYPES = new Hashtable(2);
    String vt;
    Vector<Camera> cameras;
    Portal[] portals = new Portal[0];
    public VCursor mouse;
    ViewPanel panel;
    boolean detectMultipleFullFills;
    JLabel statusBar;
    protected String name;
    boolean notifyCursorMoved = true;
    Java2DPainter[] painters = new Java2DPainter[4];

    public static boolean registerViewPanelFactory(String ptID, PanelFactory pf) {
        if (!VIEW_TYPES.containsKey(ptID)) {
            VIEW_TYPES.put(ptID, pf);
            return true;
        }
        if (VirtualSpaceManager.INSTANCE.debugModeON()) {
            System.err.println("Error registering view panel type: " + ptID + " already exists.");
        }
        return false;
    }

    public static PanelFactory getPanelFactory(String ptID) {
        return VIEW_TYPES.get(ptID);
    }

    public String getViewType() {
        return this.vt;
    }

    void initCameras(Vector<Camera> c) {
        this.cameras = c;
        for (int i = 0; i < this.cameras.size(); ++i) {
            c.elementAt(i).setOwningView(this);
        }
    }

    Portal addPortal(Portal p) {
        Portal[] tmpP = new Portal[this.portals.length + 1];
        System.arraycopy(this.portals, 0, tmpP, 0, this.portals.length);
        tmpP[this.portals.length] = p;
        this.portals = tmpP;
        p.setOwningView(this);
        return p;
    }

    void removePortal(Portal p) {
        for (int i = 0; i < this.portals.length; ++i) {
            if (this.portals[i] != p) continue;
            this.removePortalAtIndex(i);
            break;
        }
    }

    void removePortalAtIndex(int portalIndex) {
        Portal[] tmpP = new Portal[this.portals.length - 1];
        System.arraycopy(this.portals, 0, tmpP, 0, portalIndex);
        System.arraycopy(this.portals, portalIndex + 1, tmpP, portalIndex, this.portals.length - portalIndex - 1);
        this.portals = tmpP;
        this.panel.resetCursorInsidePortals();
    }

    public void setActiveRepaintInterval(int timeMillis) {
        this.activeRepaintTimer.stop();
        if (timeMillis > 0) {
            this.activeRepaintTimer.setDelay(timeMillis);
            this.activeRepaintTimer.start();
        }
    }

    public VCursor getCursor() {
        return this.mouse;
    }

    public ViewPanel getPanel() {
        return this.panel;
    }

    public void destroyView() {
        this.activeRepaintTimer.stop();
        for (ActionListener listener : this.activeRepaintTimer.getActionListeners()) {
            this.activeRepaintTimer.removeActionListener(listener);
        }
    }

    public abstract Component getFrame();

    public void setCursorIcon(int cursorType) {
        this.panel.setAWTCursor(cursorType);
    }

    public void setCursorIcon(Cursor c) {
        this.panel.setAWTCursor(c);
    }

    public void setListener(ViewListener eh) {
        for (int i = 0; i < this.cameras.size(); ++i) {
            this.setListener(eh, i);
        }
    }

    public void setListener(ViewListener eh, int layer) {
        this.panel.setListener(eh, layer);
    }

    public void setListener(ViewListener eh, Camera cam) {
        int camIdx = this.cameras.indexOf(cam);
        if (camIdx == -1) {
            throw new IllegalArgumentException("invalid Camera " + cam + "in view " + this);
        }
        this.setListener(eh, camIdx);
    }

    public void setNotifyCursorMoved(boolean b) {
        this.notifyCursorMoved = b;
    }

    public boolean getNotifyCursorMoved() {
        return this.notifyCursorMoved;
    }

    public void setStatusBarText(String s) {
        if (this.statusBar != null) {
            if (s.equals("")) {
                this.statusBar.setText(" ");
            } else {
                this.statusBar.setText(s);
            }
        }
    }

    public void setStatusBarFont(Font f) {
        if (this.statusBar != null) {
            this.statusBar.setFont(f);
        }
    }

    public void setStatusBarForeground(Color c) {
        if (this.statusBar != null) {
            this.statusBar.setForeground(c);
        }
    }

    public void setDetectMultiFills(boolean b) {
        this.detectMultipleFullFills = b;
    }

    public boolean getDetectMultiFills() {
        return this.detectMultipleFullFills;
    }

    public double[] getVisibleRegion(Camera c) {
        return this.getVisibleRegion(c, new double[4]);
    }

    public double[] getVisibleRegion(Camera c, double[] res) {
        if (this.cameras.contains(c)) {
            int nbcam = this.cameras.indexOf(c);
            double uncoef = (c.focal + c.altitude) / c.focal;
            Dimension panelSize = this.panel.getComponent().getSize();
            res[0] = c.vx - (double)(panelSize.width / 2 - this.panel.visibilityPadding[nbcam][0]) * uncoef;
            res[1] = c.vy + (double)(panelSize.height / 2 - this.panel.visibilityPadding[nbcam][1]) * uncoef;
            res[2] = c.vx + (double)(panelSize.width / 2 - this.panel.visibilityPadding[nbcam][2]) * uncoef;
            res[3] = c.vy - (double)(panelSize.height / 2 - this.panel.visibilityPadding[nbcam][3]) * uncoef;
            return res;
        }
        return null;
    }

    public double getVisibleRegionWidth(Camera c) {
        return (double)this.panel.getComponent().getSize().width * ((c.focal + c.altitude) / c.focal);
    }

    public double getVisibleRegionHeight(Camera c) {
        return (double)this.panel.getComponent().getSize().height * ((c.focal + c.altitude) / c.focal);
    }

    public void setActiveLayer(int i) {
        Camera c = this.cameras.elementAt(i);
        this.mouse.unProject(c, this.panel);
        this.mouse.getPicker().resetPickedGlyphsList(c.parentSpace, c.getIndex());
        this.panel.activeLayer = i;
    }

    public void setActiveLayer(Camera cam) {
        int camIdx = this.cameras.indexOf(cam);
        if (camIdx == -1) {
            throw new IllegalArgumentException("invalid Camera " + cam + "in view " + this);
        }
        this.setActiveLayer(camIdx);
    }

    public int getActiveLayer() {
        return this.panel.activeLayer;
    }

    public int getLayerCount() {
        return this.cameras.size();
    }

    public void updateFont() {
        this.panel.updateFont = true;
    }

    public void setAntialiasing(boolean b) {
        if (b != this.panel.antialias) {
            this.panel.antialias = b;
            this.panel.updateAntialias = true;
            this.repaint();
        }
    }

    public boolean getAntialiasing() {
        return this.panel.antialias;
    }

    public Camera getCameraNumber(int i) {
        if (this.cameras.size() > i) {
            return this.cameras.elementAt(i);
        }
        return null;
    }

    public Camera getActiveCamera() {
        return this.panel.cams[this.panel.activeLayer];
    }

    void destroyCamera(Camera c) {
        block0: for (int i = 0; i < this.panel.cams.length; ++i) {
            if (this.panel.cams[i] != c) continue;
            this.panel.cams[i] = null;
            if (i != this.panel.activeLayer) break;
            for (int j = 0; j < this.panel.cams.length; ++j) {
                if (this.panel.cams[j] == null) continue;
                this.panel.activeLayer = j;
                break block0;
            }
            break;
        }
        this.cameras.remove(c);
    }

    public void setBackgroundColor(Color c) {
        this.panel.backColor = c;
    }

    public Color getBackgroundColor() {
        return this.panel.backColor;
    }

    public abstract boolean isSelected();

    public abstract void setTitle(String var1);

    public abstract void setLocation(int var1, int var2);

    public abstract void setSize(int var1, int var2);

    public Dimension getPanelSize() {
        return this.panel.size;
    }

    public abstract void setResizable(boolean var1);

    public abstract void setVisible(boolean var1);

    public void setRefreshRate(int rr) {
        this.panel.setRefreshRate(rr);
    }

    public int getRefreshRate() {
        return this.panel.getRefreshRate();
    }

    public void setBlank(Color c) {
        if (c == null) {
            this.panel.blankColor = null;
            this.panel.notBlank = true;
            this.repaint();
        } else {
            this.panel.blankColor = c;
            this.panel.notBlank = false;
            this.repaint();
        }
    }

    public Color isBlank() {
        if (!this.panel.notBlank) {
            return this.panel.blankColor;
        }
        return null;
    }

    public void activate() {
        VirtualSpaceManager.INSTANCE.setActiveView(this);
        this.panel.repaintable = true;
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewActivated(this);
        }
    }

    public void deactivate() {
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewDeactivated(this);
        }
    }

    void iconify() {
        this.panel.repaintable = false;
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewIconified(this);
        }
    }

    void deiconify() {
        this.panel.repaintable = true;
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewDeiconified(this);
        }
    }

    protected void close() {
        if (this.panel.evHs[this.panel.activeLayer] != null) {
            this.panel.evHs[this.panel.activeLayer].viewClosing(this);
        }
    }

    public void repaint() {
        this.panel.repaintASAP = true;
    }

    public void repaint(RepaintListener rl) {
        this.panel.repaintListener = rl;
        this.repaint();
    }

    public void removeRepaintListener() {
        this.panel.repaintListener = null;
    }

    public Graphics2D getGraphicsContext() {
        return this.panel.stableRefToBackBufferGraphics;
    }

    public BufferedImage getImage() {
        BufferedImage res = null;
        BufferedImage i = this.panel.getImage();
        if (i != null) {
            res = new BufferedImage(i.getWidth(), i.getHeight(), i.getType());
            Graphics2D resg2d = res.createGraphics();
            resg2d.drawImage(i, null, 0, 0);
        }
        return res;
    }

    public BufferedImage rasterize(int w, int h) {
        return this.rasterize(w, h, null);
    }

    public BufferedImage rasterize(int w, int h, Vector<Camera> layers) {
        Camera nc;
        Dimension panelSize = this.panel.getComponent().getSize();
        float mFactor = 1.0f / Math.min((float)w / (float)panelSize.getWidth(), (float)h / (float)panelSize.getHeight());
        Vector<Camera> clones = new Vector<Camera>();
        Vector<Camera> cams = layers != null ? layers : this.cameras;
        for (int i = 0; i < cams.size(); ++i) {
            Camera c = cams.elementAt(i);
            nc = c.parentSpace.addCamera();
            nc.vx = c.vx;
            nc.vy = c.vy;
            nc.focal = c.focal;
            nc.altitude = (c.altitude + c.focal) * (double)mFactor - c.focal;
            clones.add(nc);
        }
        BufferedImage img = new OffscreenViewPanel(clones).rasterize(w, h, this.panel.backColor);
        for (int i = 0; i < clones.size(); ++i) {
            nc = (Camera)clones.elementAt(i);
            VirtualSpaceManager.INSTANCE.getVirtualSpace(nc.parentSpace.spaceName).removeCamera(nc.index);
        }
        return img;
    }

    public void setJava2DPainter(Java2DPainter p, short g) {
        this.painters[g] = p;
        this.repaint();
    }

    public Java2DPainter getJava2DPainter(short g) {
        return this.painters[g];
    }

    public String getName() {
        return this.name;
    }

    public void setLayerVisibility(boolean[] context, boolean[] lens) {
        this.panel.setLayerVisibility(context, lens);
    }

    public boolean[][] getLayerVisibility() {
        boolean[][] res = new boolean[][]{this.panel.getLayerVisibilityOfContext(), this.panel.getLayerVisibilityOfLens()};
        return res;
    }

    public void setVisibilityPadding(int[] wnesPadding, int layer) {
        this.panel.setVisibilityPadding(wnesPadding, layer);
    }

    public int[] getVisibilityPadding(int layer) {
        return this.panel.getVisibilityPadding(layer);
    }

    static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public Lens setLens(Lens l) {
        Lens res = this.panel.setLens(l);
        return res;
    }

    public Lens getLens() {
        return this.panel.getLens();
    }

    public Location getGlobalView(Camera c, float mFactor) {
        double tmpRatio;
        if (c.getOwningView() != this) {
            return null;
        }
        double[] wnes = c.parentSpace.findFarmostGlyphCoords();
        double dx = (wnes[2] + wnes[0]) / 2.0;
        double dy = (wnes[1] + wnes[3]) / 2.0;
        double[] regBounds = this.getVisibleRegion(c);
        double[] trRegBounds = new double[]{regBounds[0] + dx - c.vx, regBounds[3] + dy - c.vy};
        double currentAlt = c.getAltitude() + c.getFocal();
        double ratio = 0.0;
        if (trRegBounds[0] != 0.0) {
            ratio = (dx - wnes[0]) / (dx - trRegBounds[0]);
        }
        if (trRegBounds[1] != 0.0 && (tmpRatio = (dy - wnes[3]) / (dy - trRegBounds[1])) > ratio) {
            ratio = tmpRatio;
        }
        return new Location(dx, dy, currentAlt * Math.abs(ratio *= (double)mFactor) - c.getFocal());
    }

    public Location getGlobalView(Camera c, int d) {
        return this.getGlobalView(c, d, 1.0f);
    }

    public Location getGlobalView(Camera c, int d, float mFactor) {
        Location l = this.getGlobalView(c, mFactor);
        if (l != null) {
            Animation trans = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraTranslation(d, c, new Point2D.Double(l.vx, l.vy), false, SlowInSlowOutInterpolator.getInstance(), null);
            Animation alt = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraAltAnim(d, c, l.alt, false, SlowInSlowOutInterpolator.getInstance(), null);
            VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(trans, false);
            VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(alt, false);
        }
        return l;
    }

    public Location getGlobalView(Camera c) {
        return this.getGlobalView(c, 1.0f);
    }

    public Location centerOnGlyph(Glyph g, Camera c, int d, boolean z, float mFactor, EndAction endAction) {
        double dy;
        double dx;
        if (c.getOwningView() != this) {
            return null;
        }
        if (g instanceof VText) {
            VText t = (VText)g;
            Point2D.Double p = t.getBounds(c.getIndex());
            if (t.getTextAnchor() == 0) {
                dx = g.vx + p.x / 2.0 - c.vx;
                dy = g.vy + p.y / 2.0 - c.vy;
            } else if (t.getTextAnchor() == 1) {
                dx = g.vx - c.vx;
                dy = g.vy - c.vy;
            } else {
                dx = g.vx - p.x / 2.0 - c.vx;
                dy = g.vy - p.y / 2.0 - c.vy;
            }
        } else {
            dx = g.vx - c.vx;
            dy = g.vy - c.vy;
        }
        Animation trans = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraTranslation(d, c, new Point2D.Double(dx, dy), true, SlowInSlowOutInterpolator.getInstance(), endAction);
        VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(trans, false);
        if (z) {
            double tmpAlt;
            double newAlt = 0.0;
            if (this.panel.getComponent().getSize().width != 0) {
                newAlt = g instanceof VText ? ((VText)g).getBounds((int)c.getIndex()).x * c.focal / (double)this.panel.getComponent().getSize().width - c.focal : (g instanceof RectangularShape ? ((RectangularShape)((Object)g)).getWidth() * c.focal / (double)this.panel.getComponent().getSize().width - c.focal : g.getSize() * c.focal / (double)this.panel.getComponent().getSize().width - c.focal);
            }
            if (this.panel.getComponent().getSize().height != 0 && (tmpAlt = g instanceof VText ? ((VText)g).getBounds((int)c.getIndex()).y * c.focal / (double)this.panel.getComponent().getSize().height - c.focal : (g instanceof RectangularShape ? ((RectangularShape)((Object)g)).getHeight() * c.focal / (double)this.panel.getComponent().getSize().height - c.focal : g.getSize() * c.focal / (double)this.panel.getComponent().getSize().height - c.focal)) > newAlt) {
                newAlt = tmpAlt;
            }
            Animation altAnim = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraAltAnim(d, c, newAlt *= (double)mFactor, false, SlowInSlowOutInterpolator.getInstance(), null);
            VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(altAnim, false);
            return new Location(g.vx, g.vy, newAlt);
        }
        return new Location(g.vx, g.vy, c.getAltitude());
    }

    public Location centerOnGlyph(Glyph g, Camera c, int d) {
        return this.centerOnGlyph(g, c, d, true);
    }

    public Location centerOnGlyph(Glyph g, Camera c, int d, boolean z) {
        return this.centerOnGlyph(g, c, d, z, 1.0f);
    }

    public Location centerOnGlyph(Glyph g, Camera c, int d, boolean z, float mFactor) {
        return this.centerOnGlyph(g, c, d, z, mFactor, null);
    }

    public Location centerOnRegion(Camera c, int d, double x1, double y1, double x2, double y2) {
        return this.centerOnRegion(c, d, x1, y1, x2, y2, null);
    }

    public Location centerOnRegion(Camera c, int d, double x1, double y1, double x2, double y2, EndAction ea) {
        if (c.getOwningView() != this) {
            return null;
        }
        double minX = Math.min(x1, x2);
        double minY = Math.min(y1, y2);
        double maxX = Math.max(x1, x2);
        double maxY = Math.max(y1, y2);
        double[] wnes = new double[]{minX, maxY, maxX, minY};
        Dimension panelSize = this.getPanel().getComponent().getSize();
        int[] vp = this.panel.visibilityPadding[this.cameras.indexOf(c)];
        double nah = (wnes[2] - wnes[0]) * c.getFocal() / (double)(panelSize.width - vp[0] - vp[2]) - c.getFocal();
        double nav = (wnes[1] - wnes[3]) * c.getFocal() / (double)(panelSize.height - vp[1] - vp[3]) - c.getFocal();
        double na = Math.max(nah, nav);
        double dx = (wnes[2] + wnes[0] + (double)(vp[2] - vp[0]) * (c.getFocal() + na) / c.getFocal()) / 2.0;
        double dy = (wnes[1] + wnes[3] + (double)(vp[1] - vp[3]) * (c.getFocal() + na) / c.getFocal()) / 2.0;
        if (d > 0) {
            Animation trans = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraTranslation(d, c, new Point2D.Double(dx, dy), false, SlowInSlowOutInterpolator.getInstance(), ea);
            Animation altAnim = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createCameraAltAnim(d, c, na, false, SlowInSlowOutInterpolator.getInstance(), null);
            VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(trans, false);
            VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(altAnim, false);
        } else {
            c.setAltitude(na);
            c.moveTo(dx, dy);
        }
        return new Location(dx, dy, na);
    }

    public Point2D.Double fromPanelToVSCoordinates(int x, int y, Camera c, Point2D.Double res) {
        double ucoef = (c.focal + c.altitude) / c.focal;
        res.setLocation((double)(x - this.panel.size.width / 2) * ucoef + c.vx, (double)(this.panel.size.height / 2 - y) * ucoef + c.vy);
        return res;
    }

    public Point fromVSToPanelCoordinates(double vx, double vy, Camera c, Point res) {
        double coef = c.focal / (c.focal + c.altitude);
        res.setLocation((double)(this.panel.size.width / 2) + (vx - c.vx) * coef, (double)(this.panel.size.height / 2) - (vy - c.vy) * coef);
        return res;
    }

    static {
        View.registerViewPanelFactory(STD_VIEW, new StdViewPanelFactory());
        View.registerViewPanelFactory(OPENGL_VIEW, new GLViewPanelFactory());
    }
}

