/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runners.model.RunnerBuilder;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;
import org.junit.vintage.engine.discovery.DefensiveAllDefaultPossibilitiesBuilder;
import org.junit.vintage.engine.discovery.OrFilter;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorAwareFilter;
import org.junit.vintage.engine.discovery.TestClassRequest;
import org.junit.vintage.engine.support.UniqueIdReader;
import org.junit.vintage.engine.support.UniqueIdStringifier;

class TestClassRequestResolver {
    private static final RunnerBuilder RUNNER_BUILDER = new DefensiveAllDefaultPossibilitiesBuilder();
    private final Logger logger;
    private final UniqueIdReader uniqueIdReader;
    private final UniqueIdStringifier uniqueIdStringifier = new UniqueIdStringifier();

    TestClassRequestResolver(Logger logger) {
        this.logger = logger;
        this.uniqueIdReader = new UniqueIdReader(logger);
    }

    RunnerTestDescriptor createRunnerTestDescriptor(TestClassRequest request, UniqueId engineId) {
        Class<?> testClass = request.getTestClass();
        Runner runner = RUNNER_BUILDER.safeRunnerForClass(testClass);
        if (runner == null) {
            return null;
        }
        return this.determineRunnerTestDescriptor(testClass, runner, request.getFilters(), engineId);
    }

    private RunnerTestDescriptor determineRunnerTestDescriptor(Class<?> testClass, Runner runner, List<RunnerTestDescriptorAwareFilter> filters, UniqueId engineId) {
        RunnerTestDescriptor runnerTestDescriptor = this.createCompleteRunnerTestDescriptor(testClass, runner, engineId);
        if (!filters.isEmpty()) {
            if (runner instanceof Filterable) {
                Filter filter = this.createOrFilter(filters, runnerTestDescriptor);
                Runner filteredRunner = runnerTestDescriptor.toRequest().filterWith(filter).getRunner();
                runnerTestDescriptor = this.createCompleteRunnerTestDescriptor(testClass, filteredRunner, engineId);
            } else {
                this.logger.warn(() -> "Runner " + runner.getClass().getName() + " (used on " + testClass.getName() + ") does not support filtering and will therefore be run completely.");
            }
        }
        return runnerTestDescriptor;
    }

    private Filter createOrFilter(List<RunnerTestDescriptorAwareFilter> filters, RunnerTestDescriptor runnerTestDescriptor) {
        filters.forEach(filter -> filter.initialize(runnerTestDescriptor));
        return new OrFilter(filters);
    }

    private RunnerTestDescriptor createCompleteRunnerTestDescriptor(Class<?> testClass, Runner runner, UniqueId engineId) {
        UniqueId id = engineId.append("runner", testClass.getName());
        RunnerTestDescriptor runnerTestDescriptor = new RunnerTestDescriptor(id, testClass, runner);
        this.addChildrenRecursively(runnerTestDescriptor);
        return runnerTestDescriptor;
    }

    private void addChildrenRecursively(VintageTestDescriptor parent) {
        ArrayList children = parent.getDescription().getChildren();
        Map childrenByUniqueId = children.stream().collect(Collectors.groupingBy(this.uniqueIdReader.andThen(this.uniqueIdStringifier), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        for (Map.Entry entry : childrenByUniqueId.entrySet()) {
            String uniqueId = (String)entry.getKey();
            List childrenWithSameUniqueId = (List)entry.getValue();
            IntFunction<String> uniqueIdGenerator = this.determineUniqueIdGenerator(uniqueId, childrenWithSameUniqueId);
            for (int index = 0; index < childrenWithSameUniqueId.size(); ++index) {
                String reallyUniqueId = uniqueIdGenerator.apply(index);
                Description description = (Description)childrenWithSameUniqueId.get(index);
                UniqueId id = parent.getUniqueId().append("test", reallyUniqueId);
                VintageTestDescriptor child = new VintageTestDescriptor(id, description);
                parent.addChild((TestDescriptor)child);
                this.addChildrenRecursively(child);
            }
        }
    }

    private IntFunction<String> determineUniqueIdGenerator(String uniqueId, List<Description> childrenWithSameUniqueId) {
        if (childrenWithSameUniqueId.size() == 1) {
            return index -> uniqueId;
        }
        return index -> uniqueId + "[" + index + "]";
    }
}

