/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Defined_Reference;
import org.eclipse.titan.designer.AST.ASN1.Object.ASN1Objects;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldName;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.FixedTypeValue_FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSetElementVisitor_objectCollector;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSet_FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSet_definition;
import org.eclipse.titan.designer.AST.ASN1.Object.Object_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.Object_FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.ObjectClass;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.types.ObjectClassField_Type;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Error_Setting;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class InformationFromObj
extends Reference {
    private static final String FULLNAMEPART = ".<fieldnames>";
    public static final String INVALIDREFERENCE = "Invalid reference `{0}'' (ObjectClass, ObjectSet or Object reference was expected)";
    private static final String UNSUPPORTEDCONSTRUCT = "Sorry, this construct is not supported";
    private static final String VALUESETFROMOBJECTS_NOT_SUPPORTED = "Sorry, ValueSetFromObjects not supported";
    private static final String INVALIDNOTATION1 = "This notation is not permitted (object or objectset fieldreference was expected)";
    private static final String INVALIDNOTATION2 = "This notation is not permitted (type, (fixed- or variabletype) value or valueset fieldreference was expected)";
    private static final String INVALIDNOTATION3 = "This notation is not permitted (object, objectset, (fixed type) value or valueset fieldreference was expected)";
    private boolean isErroneous;
    protected final Defined_Reference reference;
    protected final FieldName fieldName;
    private Location location;

    public InformationFromObj(Defined_Reference reference, FieldName fieldName) {
        super(null);
        this.reference = reference;
        this.fieldName = fieldName;
        this.isErroneous = false;
        if (null != reference) {
            reference.setFullNameParent(this);
        }
        if (null != fieldName) {
            fieldName.setFullNameParent(this);
        }
    }

    @Override
    public InformationFromObj newInstance() {
        return new InformationFromObj(this.reference, this.fieldName.newInstance());
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.fieldName == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.reference.setMyScope(scope);
    }

    @Override
    public Identifier getId() {
        return this.reference.getId();
    }

    @Override
    public String getDisplayName() {
        return this.reference.getDisplayName() + this.fieldName.getDisplayName();
    }

    @Override
    public ISetting getRefdSetting(CompilationTimeStamp timestamp) {
        FieldSpecification currentFieldSpecification;
        Identifier currentFieldName;
        SettingDetectionState currentState;
        ObjectClass_Definition objectClass = null;
        ObjectSet_definition objectSet = null;
        Object_Definition object = null;
        object = new Object_Definition(null);
        ObjectSet_definition fromObjectSet = this.newObjectSetDefinitionInstance();
        this.isErroneous = false;
        ISetting temporalSetting = this.reference.getRefdSetting(timestamp);
        if (null == temporalSetting) {
            this.isErroneous = true;
            return new Error_Setting();
        }
        switch (temporalSetting.getSettingtype()) {
            case S_OS: {
                currentState = SettingDetectionState.ObjectSet;
                objectSet = ((ObjectSet)temporalSetting).getRefdLast(timestamp, null);
                objectClass = objectSet.getMyGovernor().getRefdLast(timestamp, null);
                ObjectSetElementVisitor_objectCollector objectCollector = new ObjectSetElementVisitor_objectCollector(objectSet.getLocation(), objectClass, timestamp);
                objectCollector.visitObjectSet(objectSet, false);
                fromObjectSet = this.newObjectSetDefinitionInstance(objectCollector.giveObjects());
                fromObjectSet.setMyGovernor(objectClass);
                break;
            }
            case S_O: {
                currentState = SettingDetectionState.Object;
                object = ((ASN1Object)temporalSetting).getRefdLast(timestamp, null);
                objectClass = object.getMyGovernor().getRefdLast(timestamp, null);
                break;
            }
            case S_OC: {
                currentState = SettingDetectionState.ObjectClass;
                objectClass = ((ObjectClass)temporalSetting).getRefdLast(timestamp, null);
                break;
            }
            case S_ERROR: {
                this.isErroneous = true;
                return new Error_Setting();
            }
            default: {
                this.location.reportSemanticError(MessageFormat.format(INVALIDREFERENCE, this.getDisplayName()));
                this.isErroneous = true;
                return new Error_Setting();
            }
        }
        int nofFields = this.fieldName.getNofFields();
        block43: for (int i = 0; i < nofFields - 1; ++i) {
            currentFieldName = this.fieldName.getFieldByIndex(i);
            currentFieldSpecification = objectClass.getFieldSpecifications().getFieldSpecificationByIdentifier(currentFieldName).getLast();
            if (FieldSpecification.Fieldspecification_types.FS_ERROR.equals((Object)currentFieldSpecification.getFieldSpecificationType())) {
                this.isErroneous = true;
                return new Error_Setting();
            }
            switch (currentState) {
                case ObjectClass: {
                    FieldSpecification temporalFieldspec;
                    switch (currentFieldSpecification.getFieldSpecificationType()) {
                        case FS_O: {
                            temporalFieldspec = (Object_FieldSpecification)currentFieldSpecification;
                            objectClass = ((Object_FieldSpecification)temporalFieldspec).getObjectClass().getRefdLast(timestamp, null);
                            continue block43;
                        }
                        case FS_OS: {
                            temporalFieldspec = (ObjectSet_FieldSpecification)currentFieldSpecification;
                            objectClass = ((ObjectSet_FieldSpecification)temporalFieldspec).getObjectClass().getRefdLast(timestamp, null);
                            continue block43;
                        }
                        case FS_ERROR: {
                            this.isErroneous = true;
                            return new Error_Setting();
                        }
                    }
                    this.location.reportSemanticError(INVALIDNOTATION1);
                    this.isErroneous = true;
                    return new Error_Setting();
                }
                case ObjectSet: {
                    int j;
                    ASN1Objects temporalObjects;
                    ObjectSetElementVisitor_objectCollector objectCollector;
                    FieldSpecification temporalFieldspec;
                    switch (currentFieldSpecification.getFieldSpecificationType()) {
                        case FS_O: {
                            temporalFieldspec = (Object_FieldSpecification)currentFieldSpecification;
                            objectClass = ((Object_FieldSpecification)temporalFieldspec).getObjectClass().getRefdLast(timestamp, null);
                            objectCollector = new ObjectSetElementVisitor_objectCollector(this.location, objectClass, timestamp);
                            temporalObjects = fromObjectSet.getObjs();
                            temporalObjects.trimToSize();
                            for (j = 0; j < temporalObjects.getNofObjects(); ++j) {
                                object = temporalObjects.getObjectByIndex(j).getRefdLast(timestamp, null);
                                if (!object.hasFieldSettingWithNameDefault(currentFieldName)) continue;
                                temporalSetting = object.getSettingByNameDefault(currentFieldName);
                                object = ((Object_Definition)temporalSetting).getRefdLast(timestamp, null);
                                objectCollector.visitObject(object);
                            }
                            fromObjectSet = this.newObjectSetDefinitionInstance(objectCollector.giveObjects());
                            fromObjectSet.setLocation(this.location);
                            fromObjectSet.setMyGovernor(objectClass);
                            continue block43;
                        }
                        case FS_OS: {
                            temporalFieldspec = (ObjectSet_FieldSpecification)currentFieldSpecification;
                            objectClass = ((ObjectSet_FieldSpecification)temporalFieldspec).getObjectClass().getRefdLast(timestamp, null);
                            ObjectSetElementVisitor_objectCollector objectCollector2 = new ObjectSetElementVisitor_objectCollector(this.location, objectClass, timestamp);
                            temporalObjects = fromObjectSet.getObjs();
                            for (j = 0; j < temporalObjects.getNofObjects(); ++j) {
                                object = temporalObjects.getObjectByIndex(j).getRefdLast(timestamp, null);
                                if (!object.hasFieldSettingWithNameDefault(currentFieldName)) continue;
                                temporalSetting = object.getSettingByNameDefault(currentFieldName);
                                objectSet = ((ObjectSet_definition)temporalSetting).getRefdLast(timestamp, null);
                                objectCollector2.visitObjectSet(objectSet, false);
                            }
                            fromObjectSet = this.newObjectSetDefinitionInstance(objectCollector2.giveObjects());
                            fromObjectSet.setLocation(this.location);
                            fromObjectSet.setMyGovernor(objectClass);
                            continue block43;
                        }
                        case FS_ERROR: {
                            this.isErroneous = true;
                            return new Error_Setting();
                        }
                    }
                    this.location.reportSemanticError(INVALIDNOTATION1);
                    this.isErroneous = true;
                    return new Error_Setting();
                }
                case Object: {
                    int j;
                    ASN1Objects temporalObjects;
                    ObjectSetElementVisitor_objectCollector objectCollector;
                    FieldSpecification temporalFieldspec;
                    switch (currentFieldSpecification.getFieldSpecificationType()) {
                        case FS_O: {
                            temporalFieldspec = (Object_FieldSpecification)currentFieldSpecification;
                            objectClass = ((Object_FieldSpecification)temporalFieldspec).getObjectClass().getRefdLast(timestamp, null);
                            temporalSetting = object.getSettingByNameDefault(currentFieldName);
                            object = ((Object_Definition)temporalSetting).getRefdLast(timestamp, null);
                            continue block43;
                        }
                        case FS_OS: {
                            currentState = SettingDetectionState.ObjectSet;
                            temporalFieldspec = (ObjectSet_FieldSpecification)currentFieldSpecification;
                            objectClass = ((ObjectSet_FieldSpecification)temporalFieldspec).getObjectClass().getRefdLast(timestamp, null);
                            objectCollector = new ObjectSetElementVisitor_objectCollector(fromObjectSet, timestamp);
                            temporalObjects = fromObjectSet.getObjs();
                            for (j = 0; j < temporalObjects.getNofObjects(); ++j) {
                                object = temporalObjects.getObjectByIndex(j).getRefdLast(timestamp, null);
                                if (!object.hasFieldSettingWithNameDefault(currentFieldName)) continue;
                                temporalSetting = object.getSettingByNameDefault(currentFieldName);
                                objectSet = ((ObjectSet_definition)temporalSetting).getRefdLast(timestamp, null);
                                objectCollector.visitObjectSet(objectSet, false);
                            }
                            fromObjectSet = this.newObjectSetDefinitionInstance(objectCollector.giveObjects());
                            fromObjectSet.setLocation(this.location);
                            fromObjectSet.setMyGovernor(objectClass);
                            continue block43;
                        }
                        case FS_ERROR: {
                            this.isErroneous = true;
                            return new Error_Setting();
                        }
                    }
                    this.location.reportSemanticError(INVALIDNOTATION1);
                    this.isErroneous = true;
                    return new Error_Setting();
                }
            }
        }
        currentFieldName = this.fieldName.getFieldByIndex(nofFields - 1);
        currentFieldSpecification = objectClass.getFieldSpecifications().getFieldSpecificationByIdentifier(currentFieldName).getLast();
        temporalSetting = null;
        block26 : switch (currentState) {
            case ObjectClass: {
                switch (currentFieldSpecification.getFieldSpecificationType()) {
                    case FS_T: {
                        Open_Type type = new Open_Type(objectClass, currentFieldName);
                        type.setLocation(this.location);
                        temporalSetting = type;
                        break block26;
                    }
                    case FS_V_FT: {
                        FixedTypeValue_FieldSpecification temporalFielspecification = (FixedTypeValue_FieldSpecification)currentFieldSpecification;
                        ObjectClassField_Type type = new ObjectClassField_Type(temporalFielspecification.getType(), objectClass, currentFieldName);
                        type.setLocation(this.location);
                        temporalSetting = type;
                        break block26;
                    }
                    case FS_V_VT: 
                    case FS_VS_FT: 
                    case FS_VS_VT: {
                        this.location.reportSemanticError(UNSUPPORTEDCONSTRUCT);
                        this.isErroneous = true;
                        break block26;
                    }
                    case FS_O: 
                    case FS_OS: {
                        this.location.reportSemanticError(INVALIDNOTATION2);
                        this.isErroneous = true;
                        break block26;
                    }
                }
                this.isErroneous = true;
                break;
            }
            case ObjectSet: {
                switch (currentFieldSpecification.getFieldSpecificationType()) {
                    case FS_O: {
                        Object_FieldSpecification temporalFieldspec = (Object_FieldSpecification)currentFieldSpecification;
                        objectClass = temporalFieldspec.getObjectClass().getRefdLast(timestamp, null);
                        ObjectSetElementVisitor_objectCollector objectCollector = new ObjectSetElementVisitor_objectCollector(this.location, objectClass, timestamp);
                        ASN1Objects temporalObjects = fromObjectSet.getObjs();
                        for (int j = 0; j < temporalObjects.getNofObjects(); ++j) {
                            object = temporalObjects.getObjectByIndex(j).getRefdLast(timestamp, null);
                            if (!object.hasFieldSettingWithNameDefault(currentFieldName)) continue;
                            temporalSetting = object.getSettingByNameDefault(currentFieldName);
                            object = ((Object_Definition)temporalSetting).getRefdLast(timestamp, null);
                            objectCollector.visitObject(object);
                        }
                        fromObjectSet = this.newObjectSetDefinitionInstance(objectCollector.giveObjects());
                        fromObjectSet.setLocation(this.location);
                        fromObjectSet.setMyGovernor(objectClass);
                        fromObjectSet.setMyScope(this.myScope);
                        temporalSetting = fromObjectSet;
                        break block26;
                    }
                    case FS_OS: {
                        ObjectSet_FieldSpecification temporalFieldspec = (ObjectSet_FieldSpecification)currentFieldSpecification;
                        objectClass = temporalFieldspec.getObjectClass().getRefdLast(timestamp, null);
                        ObjectSetElementVisitor_objectCollector objectCollector2 = new ObjectSetElementVisitor_objectCollector(this.location, objectClass, timestamp);
                        ASN1Objects temporalObjects = fromObjectSet.getObjs();
                        for (int j = 0; j < temporalObjects.getNofObjects(); ++j) {
                            object = temporalObjects.getObjectByIndex(j).getRefdLast(timestamp, null);
                            if (!object.hasFieldSettingWithNameDefault(currentFieldName)) continue;
                            temporalSetting = object.getSettingByNameDefault(currentFieldName);
                            objectSet = ((ObjectSet_definition)temporalSetting).getRefdLast(timestamp, null);
                            objectCollector2.visitObjectSet(objectSet, false);
                        }
                        fromObjectSet = this.newObjectSetDefinitionInstance(objectCollector2.giveObjects());
                        fromObjectSet.setLocation(this.location);
                        fromObjectSet.setMyGovernor(objectClass);
                        fromObjectSet.setMyScope(this.myScope);
                        temporalSetting = fromObjectSet;
                        break block26;
                    }
                    case FS_V_FT: 
                    case FS_VS_FT: {
                        this.location.reportSemanticError(VALUESETFROMOBJECTS_NOT_SUPPORTED);
                        this.isErroneous = true;
                        break block26;
                    }
                    case FS_ERROR: {
                        this.isErroneous = true;
                        break block26;
                    }
                }
                this.location.reportSemanticError(INVALIDNOTATION3);
                this.isErroneous = true;
                break;
            }
            case Object: {
                temporalSetting = object.getSettingByNameDefault(currentFieldName);
                break;
            }
            default: {
                this.isErroneous = true;
            }
        }
        return temporalSetting;
    }

    @Override
    public Assignment getRefdAssignment(CompilationTimeStamp timestamp, boolean checkParameterList, IReferenceChain refChain) {
        return this.reference.getRefdAssignment(timestamp, true, refChain);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.reference != null && !this.reference.accept(v)) {
            return false;
        }
        return this.fieldName == null || this.fieldName.accept(v);
    }

    protected ObjectSet_definition newObjectSetDefinitionInstance() {
        return new ObjectSet_definition();
    }

    protected ObjectSet_definition newObjectSetDefinitionInstance(ASN1Objects aObjects) {
        return new ObjectSet_definition(aObjects);
    }

    private static enum SettingDetectionState {
        ObjectClass,
        ObjectSet,
        Object;

    }
}

