/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecifications;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_root;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASN1.ObjectClass;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ObjectClass_refd
extends ObjectClass
implements IReferenceChainElement {
    private static final String OBJECTCLASSEXPECTED = "ObjectClass reference was expected";
    private final Reference reference;
    private ObjectClass_Definition referencedLast;

    public ObjectClass_refd(Reference reference) {
        this.reference = reference;
        if (null != reference) {
            reference.setFullNameParent(this);
        }
    }

    @Override
    public ObjectClass_refd newInstance() {
        ObjectClass_refd oc = new ObjectClass_refd(this.reference);
        oc.setLocation(this.reference.getLocation());
        return oc;
    }

    @Override
    public String chainedDescription() {
        return "object class reference: " + this.reference;
    }

    @Override
    public Location getChainLocation() {
        if (null != this.reference && null != this.reference.getLocation()) {
            return this.reference.getLocation();
        }
        return null;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.reference.setMyScope(scope);
    }

    protected ObjectClass getRefd(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (null != this.reference && referenceChain.add(this)) {
            Assignment assignment = this.reference.getRefdAssignment(timestamp, true, referenceChain);
            if (null == assignment) {
                return this.newObjectClassDefinitionInstance();
            }
            ISetting setting = this.reference.getRefdSetting(timestamp);
            if (ISetting.Setting_type.S_ERROR.equals((Object)setting.getSettingtype())) {
                return this.newObjectClassDefinitionInstance();
            }
            if (!ISetting.Setting_type.S_OC.equals((Object)setting.getSettingtype())) {
                this.reference.getLocation().reportSemanticError(OBJECTCLASSEXPECTED);
                return this.newObjectClassDefinitionInstance();
            }
            return (ObjectClass)setting;
        }
        return this.newObjectClassDefinitionInstance();
    }

    private ObjectClass_Definition newObjectClassDefinitionInstance() {
        return new ObjectClass_Definition();
    }

    @Override
    public ObjectClass_Definition getRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        IReferenceChain temporalReferenceChain;
        boolean newChain;
        boolean bl = newChain = null == referenceChain;
        if (newChain) {
            temporalReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        } else {
            temporalReferenceChain = referenceChain;
            temporalReferenceChain.markState();
        }
        ObjectClass objectClass = this.getRefd(timestamp, temporalReferenceChain);
        this.referencedLast = null;
        if (null != objectClass) {
            this.referencedLast = objectClass.getRefdLast(timestamp, temporalReferenceChain);
        }
        if (newChain) {
            temporalReferenceChain.release();
        } else {
            temporalReferenceChain.previousState();
        }
        return this.referencedLast;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.getRefdLast(timestamp, null);
    }

    @Override
    public void checkThisObject(CompilationTimeStamp timestamp, ASN1Object object) {
        ObjectClass_Definition temp = this.getRefdLast(timestamp, null);
        temp.checkThisObject(timestamp, object);
    }

    @Override
    public FieldSpecifications getFieldSpecifications() {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.referencedLast.getFieldSpecifications();
    }

    @Override
    public ObjectClassSyntax_root getObjectClassSyntax(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        ObjectClass_Definition temp = this.getRefdLast(timestamp, null);
        return temp.getObjectClassSyntax(timestamp);
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null != this.referencedLast) {
            this.referencedLast.addProposal(propCollector, i);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null != this.referencedLast) {
            this.referencedLast.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.reference == null || this.reference.accept(v);
    }
}

