/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Type_Assignment
extends ASN1Assignment {
    private static final String UNKNOWNTYPE = "unknown type assignment";
    private final IASN1Type type;

    public Type_Assignment(Identifier id, Ass_pard assPard, IASN1Type type) {
        super(id, assPard);
        this.type = type;
        if (null != type) {
            type.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_TYPE;
    }

    @Override
    protected ASN1Assignment internalNewInstance(Identifier identifier) {
        return new Type_Assignment(identifier, null, this.type.newInstance());
    }

    @Override
    public void setRightScope(Scope rightScope) {
        if (null != this.type) {
            this.type.setMyScope(rightScope);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.type) {
            this.type.setMyScope(scope);
        }
    }

    @Override
    public IASN1Type getType(CompilationTimeStamp timestamp) {
        if (null != this.assPard) {
            return null;
        }
        this.check(timestamp);
        return this.type;
    }

    @Override
    public IASN1Type getSetting(CompilationTimeStamp timestamp) {
        return this.getType(timestamp);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.assPard) {
            this.assPard.check(timestamp);
            return;
        }
        this.checkTTCNIdentifier();
        if (null != this.type) {
            this.type.check(timestamp);
            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            this.type.checkRecursions(timestamp, referenceChain);
            referenceChain.release();
        }
    }

    @Override
    public Object[] getOutlineChildren() {
        if (this.type instanceof IOutlineElement) {
            return ((IOutlineElement)((Object)this.type)).getOutlineChildren();
        }
        return super.getOutlineChildren();
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > i && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && null != this.type) {
                this.type.addDeclaration(declarationCollector, i + 1);
            } else if (subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
                declarationCollector.addDeclaration(this.identifier.getDisplayName(), this.identifier.getLocation(), this);
            }
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            String proposalKind = null != this.type ? this.type.getProposalDescription(new StringBuilder()).toString() : UNKNOWNTYPE;
            propCollector.addProposal(this.identifier, " - " + proposalKind, ImageCache.getImage(this.getOutlineIcon()), proposalKind);
        } else if (subrefs.size() > i + 1 && null != this.type && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.type.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public String getAssignmentName() {
        return "type";
    }

    @Override
    public String getOutlineIcon() {
        if (this.type instanceof IOutlineElement) {
            return ((IOutlineElement)((Object)this.type)).getOutlineIcon();
        }
        return "type.gif";
    }

    @Override
    public Location getLikelyLocation() {
        if (this.type != null) {
            return Location.interval(super.getLikelyLocation(), this.type.getLikelyLocation());
        }
        return super.getLikelyLocation();
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.type == null || this.type.accept(v);
    }
}

