/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class PortReference
extends Reference {
    private static final String NOPORTWITHNAME = "Component type `{0}'' does not have a port with name `{1}''";
    private Component_Type componentType;

    public PortReference(Reference reference) {
        super(null, reference.getSubreferences());
    }

    public void setComponent(Component_Type componentType) {
        this.componentType = componentType;
    }

    @Override
    public Reference newInstance() {
        ErrorReporter.INTERNAL_ERROR((String)"Port referencies should not be cloned");
        return null;
    }

    @Override
    public Assignment getRefdAssignment(CompilationTimeStamp timestamp, boolean checkParameterList) {
        if (this.myScope == null || this.componentType == null) {
            return null;
        }
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.referredAssignment;
        }
        Identifier portIdentifier = this.getId();
        ComponentTypeBody componentBody = this.componentType.getComponentBody();
        if (!componentBody.hasLocalAssignmentWithId(portIdentifier)) {
            this.getLocation().reportSemanticError(MessageFormat.format(NOPORTWITHNAME, this.componentType.getTypename(), portIdentifier.getDisplayName()));
            this.referredAssignment = null;
            this.lastTimeChecked = timestamp;
            return null;
        }
        this.referredAssignment = componentBody.getLocalAssignmentById(portIdentifier);
        if (this.referredAssignment != null) {
            String referingModuleName;
            this.referredAssignment.check(timestamp);
            this.referredAssignment.setUsed();
            if (this.referredAssignment instanceof Definition && !((Definition)this.referredAssignment).referingHere.contains(referingModuleName = this.getMyScope().getModuleScope().getName())) {
                ((Definition)this.referredAssignment).referingHere.add(referingModuleName);
            }
        }
        this.lastTimeChecked = timestamp;
        return this.referredAssignment;
    }
}

