/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.util.ArrayList;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ActualParameterList
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".<parameter";
    private ArrayList<ActualParameter> parameters;

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.parameters == null) {
            return;
        }
        this.parameters.trimToSize();
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.parameters == null) {
            return builder;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i + 1)).append(">");
        }
        return builder;
    }

    public void addParameter(ActualParameter parameter) {
        if (parameter != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList(1);
            }
            this.parameters.add(parameter);
            parameter.setFullNameParent(this);
        }
    }

    public int getNofParameters() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public ActualParameter getParameter(int index) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(index);
    }

    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.parameters == null) {
            return;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.parameters == null) {
            return;
        }
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            ActualParameter parameter = this.parameters.get(i);
            parameter.updateSyntax(reparser, false);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.parameters != null) {
            for (ActualParameter ap : this.parameters) {
                if (ap.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

