/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.DecodeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.EncodeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorList;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PrintingAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PrintingType;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PrototypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_Extfunction
extends Definition
implements IParameterisedAssignment {
    private static final String FULLNAMEPART1 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART2 = ".<type>";
    private static final String FULLNAMEPART3 = ".<errorbehavior_list>";
    public static final String PORTRETURNNOTALLOWED = "External functions can not return ports";
    private static final String KIND = "external function";
    private final Assignment.Assignment_type assignmentType;
    private final FormalParameterList formalParList;
    private final Type returnType;
    private final boolean returnsTemplate;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private Def_Function.EncodingPrototype_type prototype;
    private Type inputType;
    private Type outputType;
    private ExternalFunctionEncodingType_type functionEncodingType;
    private IType.Encoding_type encodingType;
    private String encodingOptions;
    private ErrorBehaviorList errorBehaviorList;
    private PrintingType printingType;

    public Def_Extfunction(Identifier identifier, FormalParameterList formalParameters, Type returnType, boolean returnsTemplate, TemplateRestriction.Restriction_type templateRestriction) {
        super(identifier);
        this.assignmentType = returnType == null ? Assignment.Assignment_type.A_EXT_FUNCTION : (returnsTemplate ? Assignment.Assignment_type.A_EXT_FUNCTION_RTEMP : Assignment.Assignment_type.A_EXT_FUNCTION_RVAL);
        this.formalParList = formalParameters;
        this.formalParList.setMyDefinition(this);
        this.returnType = returnType;
        this.returnsTemplate = returnsTemplate;
        this.templateRestriction = templateRestriction;
        this.prototype = Def_Function.EncodingPrototype_type.NONE;
        this.functionEncodingType = ExternalFunctionEncodingType_type.MANUAL;
        this.encodingType = IType.Encoding_type.UNDEFINED;
        this.encodingOptions = null;
        this.errorBehaviorList = null;
        this.printingType = null;
        this.formalParList.setFullNameParent(this);
        if (returnType != null) {
            returnType.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return this.assignmentType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.formalParList == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.returnType == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.errorBehaviorList == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    @Override
    public FormalParameterList getFormalParameterList() {
        return this.formalParList;
    }

    public Def_Function.EncodingPrototype_type getPrototype() {
        return this.prototype;
    }

    public Type getInputType() {
        return this.inputType;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getOutlineIcon() {
        if (this.returnType == null) {
            return "function_external.gif";
        }
        return "function_external_return.gif";
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.formalParList.setMyScope(scope);
        if (this.returnType != null) {
            this.returnType.setMyScope(scope);
        }
        scope.addSubScope(this.formalParList.getLocation(), this.formalParList);
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.returnType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isUsed = false;
        this.prototype = Def_Function.EncodingPrototype_type.NONE;
        this.functionEncodingType = ExternalFunctionEncodingType_type.MANUAL;
        this.encodingType = IType.Encoding_type.UNDEFINED;
        this.encodingOptions = null;
        this.errorBehaviorList = null;
        this.printingType = null;
        this.lastTimeChecked = timestamp;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionExternalFunction", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.returnType != null) {
            this.returnType.check(timestamp);
            IType returnedType = this.returnType.getTypeRefdLast(timestamp);
            if (returnedType != null && IType.Type_type.TYPE_PORT.equals((Object)returnedType.getTypetype()) && this.returnType.getLocation() != null) {
                this.returnType.getLocation().reportSemanticError(PORTRETURNNOTALLOWED);
            }
        }
        this.formalParList.reset();
        this.formalParList.check(timestamp, this.getAssignmentType());
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
            this.analyzeExtensionAttributes(timestamp);
            this.checkPrototype(timestamp);
            this.checkFunctionType(timestamp);
        }
    }

    @Override
    public void postCheck() {
        super.postCheck();
        this.postCheckPrivateness();
    }

    public void analyzeExtensionAttributes(CompilationTimeStamp timestamp) {
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        int size = realAttributes.size();
        for (int i = 0; i < size; ++i) {
            Qualifiers qualifiers;
            SingleWithAttribute attribute = realAttributes.get(i);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        int size2 = specifications.size();
        for (int i = 0; i < size2; ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        int size3 = attributes.size();
        block19: for (int i = 0; i < size3; ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            switch (extensionAttribute.getAttributeType()) {
                case PROTOTYPE: {
                    if (Def_Function.EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
                        this.prototype = ((PrototypeAttribute)extensionAttribute).getPrototypeType();
                        continue block19;
                    }
                    this.location.reportSemanticError("duplicate attribute `prototype'.");
                    continue block19;
                }
                case ENCODE: {
                    switch (this.functionEncodingType) {
                        case MANUAL: {
                            break;
                        }
                        case ENCODE: {
                            this.location.reportSemanticError("duplicate attribute `encode'.");
                            break;
                        }
                        case DECODE: {
                            this.location.reportSemanticError("`decode' and `encode' attributes cannot be used at the same time.");
                            break;
                        }
                    }
                    this.encodingType = ((EncodeAttribute)extensionAttribute).getEncodingType();
                    this.encodingOptions = ((EncodeAttribute)extensionAttribute).getOptions();
                    this.functionEncodingType = ExternalFunctionEncodingType_type.ENCODE;
                    continue block19;
                }
                case DECODE: {
                    switch (this.functionEncodingType) {
                        case MANUAL: {
                            break;
                        }
                        case ENCODE: {
                            this.location.reportSemanticError("`decode' and `encode' attributes cannot be used at the same time.");
                            break;
                        }
                        case DECODE: {
                            this.location.reportSemanticError("duplicate attribute `decode'.");
                            break;
                        }
                    }
                    this.encodingType = ((DecodeAttribute)extensionAttribute).getEncodingType();
                    this.encodingOptions = ((DecodeAttribute)extensionAttribute).getOptions();
                    this.functionEncodingType = ExternalFunctionEncodingType_type.DECODE;
                    continue block19;
                }
                case ERRORBEHAVIOR: {
                    if (this.errorBehaviorList == null) {
                        this.errorBehaviorList = ((ErrorBehaviorAttribute)extensionAttribute).getErrrorBehaviorList();
                        continue block19;
                    }
                    this.errorBehaviorList.addAllBehaviors(((ErrorBehaviorAttribute)extensionAttribute).getErrrorBehaviorList());
                    continue block19;
                }
                case PRINTING: {
                    if (this.printingType == null) {
                        this.printingType = ((PrintingAttribute)extensionAttribute).getPrintingType();
                        continue block19;
                    }
                    this.location.reportSemanticError("duplicate attribute `printing'.");
                    continue block19;
                }
            }
        }
    }

    private void checkPrototype(CompilationTimeStamp timestamp) {
        if (Def_Function.EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
            return;
        }
        if (Def_Function.EncodingPrototype_type.CONVERT.equals((Object)this.prototype)) {
            if (this.formalParList.getNofParameters() == 1) {
                FormalParameter parameter = this.formalParList.getParameterByIndex(0);
                switch (parameter.getRealAssignmentType()) {
                    case A_PAR_VAL: 
                    case A_PAR_VAL_IN: {
                        this.inputType = parameter.getType(timestamp);
                        break;
                    }
                    default: {
                        String message = MessageFormat.format("The parameter must be an `in'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), parameter.getAssignmentName());
                        parameter.getLocation().reportSemanticError(message);
                        break;
                    }
                }
            } else {
                String message = MessageFormat.format("The external function must have one parameter instead of {0} for attribute `prototype({1})''", this.formalParList.getNofParameters(), this.prototype.getName());
                this.formalParList.getLocation().reportSemanticError(message);
            }
        } else if (this.formalParList.getNofParameters() == 2) {
            FormalParameter firstParameter = this.formalParList.getParameterByIndex(0);
            if (Def_Function.EncodingPrototype_type.SLIDING.equals((Object)this.prototype)) {
                if (Assignment.Assignment_type.A_PAR_VAL_INOUT.equals(firstParameter.getRealAssignmentType())) {
                    Type firstParameterType = firstParameter.getType(timestamp);
                    IType last = firstParameterType.getTypeRefdLast(timestamp);
                    if (last.getIsErroneous(timestamp)) {
                        this.inputType = firstParameterType;
                    } else {
                        switch (last.getTypetypeTtcn3()) {
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: 
                            case TYPE_BITSTRING: {
                                this.inputType = firstParameterType;
                                break;
                            }
                            default: {
                                String message = MessageFormat.format("The type of the first parameter must be `octetstring'' or `charstring'' for attribute `prototype({0})''", this.prototype.getName());
                                firstParameter.getLocation().reportSemanticError(message);
                                break;
                            }
                        }
                    }
                } else {
                    firstParameter.getLocation().reportSemanticError(MessageFormat.format("The first parameter must be an `inout'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), firstParameter.getAssignmentName()));
                }
            } else if (Assignment.Assignment_type.A_PAR_VAL_IN.equals(firstParameter.getRealAssignmentType()) || Assignment.Assignment_type.A_PAR_VAL.equals(firstParameter.getRealAssignmentType())) {
                this.inputType = firstParameter.getType(timestamp);
            } else {
                firstParameter.getLocation().reportSemanticError(MessageFormat.format("The first parameter must be an `in'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), firstParameter.getAssignmentName()));
            }
            FormalParameter secondParameter = this.formalParList.getParameterByIndex(1);
            if (Assignment.Assignment_type.A_PAR_VAL_OUT.equals(secondParameter.getRealAssignmentType())) {
                this.outputType = secondParameter.getType(timestamp);
            } else {
                secondParameter.getLocation().reportSemanticError(MessageFormat.format("The second parameter must be an `out'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), secondParameter.getAssignmentName()));
            }
        } else {
            this.formalParList.getLocation().reportSemanticError(MessageFormat.format("The function must have two parameters for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), this.formalParList.getNofParameters()));
        }
        if (Def_Function.EncodingPrototype_type.FAST.equals((Object)this.prototype)) {
            if (this.returnType != null) {
                this.returnType.getLocation().reportSemanticError(MessageFormat.format("The external function cannot have return type fo attribute `prototype({0})''", this.prototype.getName()));
            }
        } else if (this.returnType == null) {
            this.location.reportSemanticError(MessageFormat.format("The external function must have a return type for attribute `prototype({0})''", this.prototype.getName()));
        } else {
            if (Assignment.Assignment_type.A_FUNCTION_RTEMP.equals(this.assignmentType)) {
                this.returnType.getLocation().reportSemanticError(MessageFormat.format("The external function must return a value instead of a template for attribute `prototype({0})''", this.prototype.getName()));
            }
            if (Def_Function.EncodingPrototype_type.CONVERT.equals((Object)this.prototype)) {
                this.outputType = this.returnType;
            } else {
                IType last = this.returnType.getTypeRefdLast(timestamp);
                if (!last.getIsErroneous(timestamp) && !IType.Type_type.TYPE_INTEGER.equals((Object)last.getTypetypeTtcn3())) {
                    this.returnType.getLocation().reportSemanticError(MessageFormat.format("The return type of the function must be `integer'' instead of `{0}'' for attribute `prototype({1})''", this.returnType.getTypename(), this.prototype.getName()));
                }
            }
        }
    }

    public void checkFunctionType(CompilationTimeStamp timestamp) {
        switch (this.functionEncodingType) {
            case MANUAL: {
                if (this.errorBehaviorList == null) break;
                this.errorBehaviorList.getLocation().reportSemanticError("Attribute `errorbehavior' can only be used together with `encode' or `decode'");
                this.errorBehaviorList.check(timestamp);
                break;
            }
            case ENCODE: {
                switch (this.prototype) {
                    case NONE: {
                        this.location.reportSemanticError("Attribute `encode' cannot be used without `prototype'");
                        break;
                    }
                    case BACKTRACK: 
                    case SLIDING: {
                        this.location.reportSemanticError(MessageFormat.format("Attribute `encode'' cannot be used without `prototype({0})''", this.prototype.getName()));
                        break;
                    }
                }
                if (this.errorBehaviorList != null) {
                    this.errorBehaviorList.check(timestamp);
                }
                if (this.printingType == null) break;
                this.printingType.check(timestamp);
                break;
            }
            case DECODE: {
                if (Def_Function.EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
                    this.location.reportSemanticError("Attribute `decode' cannot be used without `prototype'");
                }
                if (this.errorBehaviorList == null) break;
                this.errorBehaviorList.check(timestamp);
                break;
            }
        }
        if (this.printingType != null && (this.functionEncodingType != ExternalFunctionEncodingType_type.ENCODE || this.encodingType != IType.Encoding_type.JSON)) {
            this.location.reportSemanticError("Attribute `printing' is only allowed for JSON encoding functions");
        }
    }

    @Override
    public String getProposalDescription() {
        StringBuilder nameBuilder = new StringBuilder(this.identifier.getDisplayName());
        nameBuilder.append('(');
        this.formalParList.getAsProposalDesriptionPart(nameBuilder);
        nameBuilder.append(')');
        return nameBuilder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            StringBuilder patternBuilder = new StringBuilder(this.identifier.getDisplayName());
            patternBuilder.append('(');
            this.formalParList.getAsProposalPart(patternBuilder);
            patternBuilder.append(')');
            propCollector.addTemplateProposal(this.identifier.getDisplayName(), new Template(this.getProposalDescription(), "", propCollector.getContextIdentifier(), patternBuilder.toString(), false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            super.addProposal(propCollector, i);
        } else if (subrefs.size() > i + 1 && this.returnType != null && ISubReference.Subreference_type.parameterisedSubReference.equals((Object)subrefs.get(i).getReferenceType()) && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.returnType.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
            if (subrefs.size() > i + 1 && this.returnType != null) {
                this.returnType.addDeclaration(declarationCollector, i + 1);
            } else {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public String getOutlineText() {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        StringBuilder text = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParList == null) {
            return text.toString();
        }
        text.append('(');
        for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                text.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.equals((parameter = this.formalParList.getParameterByIndex(i)).getRealAssignmentType())) {
                text.append("timer");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                text.append("Unknown type");
                continue;
            }
            text.append(type.getTypename());
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return this.templateRestriction;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.formalParList != null) {
                if (enveloped) {
                    this.formalParList.updateSyntax(reparser, false);
                    reparser.updateLocation(this.formalParList.getLocation());
                } else if (reparser.envelopsDamage(this.formalParList.getLocation())) {
                    this.formalParList.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.formalParList.getLocation());
                }
            }
            if (this.returnType != null) {
                if (enveloped) {
                    this.returnType.updateSyntax(reparser, false);
                    reparser.updateLocation(this.returnType.getLocation());
                } else if (reparser.envelopsDamage(this.returnType.getLocation())) {
                    this.returnType.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.returnType.getLocation());
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    this.withAttributesPath.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.returnType != null) {
            this.returnType.updateSyntax(reparser, false);
            reparser.updateLocation(this.returnType.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.returnType != null) {
            this.returnType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        return this.returnType == null || this.returnType.accept(v);
    }

    public static enum ExternalFunctionEncodingType_type {
        MANUAL,
        ENCODE,
        DECODE;

    }
}

