/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.Altstep_Applied_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Function_Applied_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Unknown_Applied_Statement
extends Statement {
    private static final String FUNCTIONORALTSTEPVALUEXPECTED = "A value of type function or altstep was expected instead of `{0}''";
    private static final String UNUSEDRETURNVALUE = "The value returned by function type `{0}'' is not used";
    private static final String FULLNAMEPART1 = ".reference";
    private static final String FULLNAMEPART2 = ".<parameters>";
    private static final String STATEMENT_NAME = "function or altstep type application";
    private final Value dereferredValue;
    private final ParsedActualParameters actualParameterList;
    private Statement realStatement;
    private int statementIndex;

    public Unknown_Applied_Statement(Value dereferredValue, ParsedActualParameters actualParameterList) {
        this.dereferredValue = dereferredValue;
        this.actualParameterList = actualParameterList;
        if (dereferredValue != null) {
            dereferredValue.setFullNameParent(this);
        }
        if (actualParameterList != null) {
            actualParameterList.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_UNKNOWN_APPLIED_INSTANE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.dereferredValue == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.actualParameterList == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.dereferredValue != null) {
            this.dereferredValue.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        this.statementIndex = index;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.dereferredValue == null) {
            return;
        }
        this.dereferredValue.setLoweridToReference(timestamp);
        IType type = this.dereferredValue.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (type != null) {
            type = type.getTypeRefdLast(timestamp);
        }
        if (type == null) {
            return;
        }
        ActualParameterList tempActualParameters = new ActualParameterList();
        switch (type.getTypetype()) {
            case TYPE_FUNCTION: {
                if (this.realStatement == null || !Statement.Statement_type.S_FUNCTION_APPLIED.equals((Object)this.realStatement.getType())) {
                    this.realStatement = new Function_Applied_Statement(this.dereferredValue, this.actualParameterList);
                    this.realStatement.setFullNameParent(this);
                    this.realStatement.setLocation(this.location);
                    this.realStatement.setMyStatementBlock(this.getMyStatementBlock(), this.statementIndex);
                }
                this.realStatement.check(timestamp);
                if (((Function_Type)type).getReturnType() != null) {
                    this.location.reportConfigurableSemanticProblem(Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnusedFunctionReturnValues", "warning", null), MessageFormat.format(UNUSEDRETURNVALUE, type.getTypename()));
                }
                FormalParameterList formalParameterList = ((Function_Type)type).getFormalParameters();
                formalParameterList.checkActualParameterList(timestamp, this.actualParameterList, tempActualParameters);
                break;
            }
            case TYPE_ALTSTEP: {
                if (this.realStatement == null || !Statement.Statement_type.S_ALTSTEP_APPLIED.equals((Object)this.realStatement.getType())) {
                    this.realStatement = new Altstep_Applied_Statement(this.dereferredValue, this.actualParameterList);
                    this.realStatement.setFullNameParent(this);
                    this.realStatement.setLocation(this.location);
                    this.realStatement.setMyStatementBlock(this.getMyStatementBlock(), this.statementIndex);
                }
                this.realStatement.check(timestamp);
                FormalParameterList formalParameterList = ((Altstep_Type)type).getFormalParameters();
                formalParameterList.checkActualParameterList(timestamp, this.actualParameterList, tempActualParameters);
                break;
            }
            default: {
                this.dereferredValue.getLocation().reportSemanticError(MessageFormat.format(FUNCTIONORALTSTEPVALUEXPECTED, type.getTypename()));
            }
        }
        if (this.myStatementBlock != null) {
            this.myStatementBlock.checkRunsOnScope(timestamp, type, (ILocateableNode)this, "call");
        }
    }

    @Override
    public void checkAllowedInterleave() {
        if (this.realStatement != null) {
            this.realStatement.checkAllowedInterleave();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.dereferredValue != null) {
            this.dereferredValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.dereferredValue.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.realStatement != null) {
            this.realStatement.findReferences(referenceFinder, foundIdentifiers);
        } else {
            if (this.dereferredValue != null) {
                this.dereferredValue.findReferences(referenceFinder, foundIdentifiers);
            }
            if (this.actualParameterList != null) {
                this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.realStatement != null) {
            return this.realStatement.accept(v);
        }
        if (this.dereferredValue != null && !this.dereferredValue.accept(v)) {
            return false;
        }
        return this.actualParameterList == null || this.actualParameterList.accept(v);
    }
}

