/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.LengthRestriction;
import org.eclipse.titan.designer.AST.TTCN3.types.Integer_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class RangeLenghtRestriction
extends LengthRestriction {
    private static final String FULLNAMEPART1 = ".<lower>";
    private static final String FULLNAMEPART2 = ".<upper>";
    private final Value lower;
    private final Value upper;
    private CompilationTimeStamp lastTimeChecked;

    public RangeLenghtRestriction(Value lower, Value upper) {
        this.lower = lower;
        this.upper = upper;
        if (lower != null) {
            lower.setFullNameParent(this);
        }
        if (upper != null) {
            upper.setFullNameParent(this);
        }
    }

    @Override
    public String createStringRepresentation() {
        if (this.lower == null) {
            return "<erroneous length restriction>";
        }
        StringBuilder builder = new StringBuilder("length(");
        builder.append(this.lower.createStringRepresentation());
        builder.append(" .. ");
        if (this.upper != null) {
            builder.append(this.upper.createStringRepresentation());
        } else {
            builder.append("infinity");
        }
        builder.append(')');
        return builder.toString();
    }

    public IValue getLowerValue(CompilationTimeStamp timestamp) {
        if (this.lower == null) {
            return null;
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.lower.getValueRefdLast(timestamp, chain);
        chain.release();
        return last;
    }

    public IValue getUpperValue(CompilationTimeStamp timestamp) {
        if (this.upper == null) {
            return null;
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.upper.getValueRefdLast(timestamp, chain);
        chain.release();
        return last;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.lower != null) {
            this.lower.setMyScope(scope);
        }
        if (this.upper != null) {
            this.upper.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.lower == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.upper == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        BigInteger lowerInt;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        Integer_Type integer = new Integer_Type();
        this.lower.setMyGovernor(integer);
        IValue last = integer.checkThisValueRef(timestamp, this.lower);
        integer.checkThisValueLimit(timestamp, last, expectedValue, false, false, true, false);
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue valueLower = last.getValueRefdLast(timestamp, chain);
        chain.release();
        if (last.getIsErroneous(timestamp)) {
            return;
        }
        switch (valueLower.getValuetype()) {
            case INTEGER_VALUE: {
                lowerInt = ((Integer_Value)valueLower).getValueValue();
                if (lowerInt.compareTo(BigInteger.ZERO) != -1) break;
                String message = MessageFormat.format("The lower boundary of the length restriction must be a non-negative integer value instead of {0}", lowerInt);
                valueLower.getLocation().reportSemanticError(message);
                break;
            }
            default: {
                lowerInt = BigInteger.ZERO;
            }
        }
        if (this.upper == null) {
            return;
        }
        this.upper.setMyGovernor(integer);
        last = integer.checkThisValueRef(timestamp, this.upper);
        integer.checkThisValueLimit(timestamp, last, expectedValue, false, false, true, false);
        chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue valueUpper = last.getValueRefdLast(timestamp, chain);
        chain.release();
        if (last.getIsErroneous(timestamp)) {
            return;
        }
        switch (valueUpper.getValuetype()) {
            case INTEGER_VALUE: {
                BigInteger upperInt = ((Integer_Value)valueUpper).getValueValue();
                if (upperInt.compareTo(BigInteger.ZERO) == -1) {
                    String message = MessageFormat.format("The upper boundary of the length restriction must be a non-negative integer value instead of {0}", upperInt);
                    valueUpper.getLocation().reportSemanticError(message);
                    break;
                }
                if (upperInt.compareTo(lowerInt) != -1) break;
                this.getLocation().reportSemanticError(MessageFormat.format("The upper boundary of the length restriction ({0}) cannot be smaller than the lower boundary {1}", upperInt, lowerInt));
                break;
            }
        }
    }

    @Override
    public void checkArraySize(CompilationTimeStamp timestamp, ArrayDimension dimension) {
        if (this.lastTimeChecked == null || dimension.getIsErroneous(timestamp)) {
            return;
        }
        boolean errorFlag = false;
        long arraySize = dimension.getSize();
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue lowerLast = this.lower.getValueRefdLast(timestamp, chain);
        chain.release();
        if (IValue.Value_type.INTEGER_VALUE.equals((Object)lowerLast.getValuetype()) && !lowerLast.getIsErroneous(timestamp)) {
            String message;
            BigInteger length = ((Integer_Value)lowerLast).getValueValue();
            if (length.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                message = MessageFormat.format("An integer value less then `{0}'' was expected as the lower boundary of the length restriction instead of `{1}''", Integer.MAX_VALUE, length);
                this.lower.getLocation().reportSemanticError(message);
                errorFlag = true;
            } else if (length.compareTo(BigInteger.valueOf(arraySize)) == 1) {
                message = MessageFormat.format("There number of elements allowed by the length restriction (at least {0}) contradicts the array size ({1})", length, arraySize);
                this.lower.getLocation().reportSemanticError(message);
                errorFlag = true;
            }
        }
        if (this.upper != null) {
            chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IValue upperLast = this.upper.getValueRefdLast(timestamp, chain);
            chain.release();
            if (IValue.Value_type.INTEGER_VALUE.equals((Object)upperLast.getValuetype()) && !upperLast.getIsErroneous(timestamp)) {
                BigInteger length = ((Integer_Value)upperLast).getValueValue();
                if (length.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                    String message = MessageFormat.format("An integer value less then `{0}'' was expected as the upper boundary of the length restriction instead of `{1}''", Integer.MAX_VALUE, length);
                    this.upper.getLocation().reportSemanticError(message);
                    errorFlag = true;
                } else if (length.compareTo(BigInteger.valueOf(arraySize)) == 1) {
                    String message = MessageFormat.format("There number of elements allowed by the length restriction (at most {0}) contradicts the array size ({1})", length, arraySize);
                    this.upper.getLocation().reportSemanticError(message);
                    errorFlag = true;
                }
            }
        }
        if (!errorFlag) {
            this.getLocation().reportSemanticWarning("Length restriction is useless for an array template");
        }
    }

    @Override
    public void checkNofElements(CompilationTimeStamp timestamp, int nofElements, boolean lessAllowed, boolean moreAllowed, boolean hasAnyornone, ILocateableNode locatable) {
        String message;
        BigInteger length;
        IValue last;
        ReferenceChain chain;
        if (this.lower == null) {
            return;
        }
        if (!lessAllowed) {
            chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            last = this.lower.getValueRefdLast(timestamp, chain);
            chain.release();
            if (IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype()) && !last.getIsErroneous(timestamp) && (length = ((Integer_Value)last).getValueValue()).compareTo(BigInteger.valueOf(nofElements)) == 1) {
                message = MessageFormat.format("There are fewer ({0}) elements than it is allowed by the length restriction (at least {1})", nofElements, length);
                locatable.getLocation().reportSemanticError(message);
            }
        }
        if (this.upper == null) {
            return;
        }
        chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        last = this.upper.getValueRefdLast(timestamp, chain);
        chain.release();
        if (IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype()) && !last.getIsErroneous(timestamp) && (length = ((Integer_Value)last).getValueValue()).compareTo(BigInteger.valueOf(nofElements)) == -1 && !moreAllowed) {
            message = MessageFormat.format("There are more ({0} {1}) elements than it is allowed by the length restriction ({2})", hasAnyornone ? "at least" : "", nofElements, length);
            locatable.getLocation().reportSemanticError(message);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lower != null) {
            this.lower.updateSyntax(reparser, false);
            reparser.updateLocation(this.lower.getLocation());
        }
        if (this.upper != null) {
            this.upper.updateSyntax(reparser, false);
            reparser.updateLocation(this.upper.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.lower != null) {
            this.lower.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.upper != null) {
            this.upper.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.lower != null && !this.lower.accept(v)) {
            return false;
        }
        return this.upper == null || this.upper.accept(v);
    }
}

