/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.CompositeTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.AST.TTCN3.templates.ListOfTemplates;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ValueList_Template
extends CompositeTemplate {
    public ValueList_Template(ListOfTemplates templates) {
        super(templates);
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.VALUE_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous value list match";
        }
        return "value list match";
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IType type = this.templates.getTemplateByIndex(i).getExpressionGovernor(timestamp, expectedValue);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IType.Type_type type = this.templates.getTemplateByIndex(i).getExpressionReturntype(timestamp, expectedValue);
            if (IType.Type_type.TYPE_UNDEFINED.equals((Object)type)) continue;
            return type;
        }
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        if (type == null) {
            return;
        }
        boolean allowOmitInValueList = this.allowOmitInValueList(allowOmit);
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            ITemplateListItem component = this.templates.getTemplateByIndex(i);
            component.setMyGovernor(type);
            ITTCN3Template temporalComponent = type.checkThisTemplateRef(timestamp, component);
            temporalComponent.checkThisTemplateGeneric(timestamp, type, false, allowOmitInValueList, true, subCheck, implicitOmit);
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent && this.location != null && !(this.location instanceof NULL_Location)) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value was expected instead of value list match");
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        boolean needsRuntimeCheck = false;
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            ITemplateListItem component = this.templates.getTemplateByIndex(i);
            if (!component.checkPresentRestriction(timestamp, definitionName, usageLocation)) continue;
            needsRuntimeCheck = true;
        }
        return needsRuntimeCheck;
    }

    @Override
    protected String getNameForStringRep() {
        return "";
    }
}

